/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.configintermediary.compat;

import com.jab125.configintermediary.ConfigIntermediary;
import com.jab125.configintermediary.api.event.LoadEvent;
import com.jab125.configintermediary.api.event.SaveEvent;
import com.jab125.configintermediary.api.value.ArrayConfigValue;
import com.jab125.configintermediary.api.value.Config;
import com.jab125.configintermediary.api.value.ConfigValue;
import com.jab125.configintermediary.api.value.ObjectConfigValue;
import com.jab125.configintermediary.api.value.TransitiveConfigValue;
import com.jab125.configintermediary.compat.TransitiveConfigValueBuilder;
import com.jab125.configintermediary.mixin.autoconfig.ConfigManagerAccessor;
import com.jab125.configintermediary.util.ReflectionUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.ConfigManager;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public class AutoConfigCompat {
    private static final ConfigValue TRANSITIVE = new ConfigValue(){

        public Object get() {
            return null;
        }

        public Object getDefaultValue() {
            return null;
        }

        public void resetToDefault() {
        }

        public void set(Object value) {
        }

        public Class<?> getType() {
            return null;
        }
    };
    public static Logger LOGGER = LoggerFactory.getLogger((String)"config-intermediary-auto-config-compat");

    public static Config register(ConfigHolder<?> data) {
        ConfigManager configManager;
        if (data instanceof ConfigManager && (configManager = (ConfigManager)data) instanceof ConfigManagerAccessor) {
            ConfigManagerAccessor accessor = (ConfigManagerAccessor)configManager;
            String modId = accessor.getDefinition().name();
            LOGGER.info("Found config for: " + modId);
            ConfigData config = configManager.getConfig();
            return AutoConfigCompat.createObjectBased(((Supplier<Object>)() -> {
                try {
                    return configManager.getConfigClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).get(), modId, config, configManager);
        }
        return null;
    }

    private static Config createObjectBased(final Object defaultObject, final String modId, @NotNull Object config, final ConfigManager configManager) {
        TransitiveConfigValueBuilder.ConfigBuilder builder = TransitiveConfigValueBuilder.builder((TransitiveConfigValueBuilder.ConfigDelegate)new TransitiveConfigValueBuilder.ConfigDelegate(){

            public void save() {
                configManager.save();
            }

            public void load() {
                configManager.load();
            }

            public Object getAsDefault() {
                return defaultObject;
            }

            public Object get() {
                return configManager.getConfig();
            }

            public void set(Object val) {
                configManager.setConfig((ConfigData)val);
            }

            public void onSave(SaveEvent saveEvent) {
                configManager.registerSaveListener((configHolder, configData) -> saveEvent.onSave(this.getFutureConfig(), (Object)configData));
            }

            public void onLoad(LoadEvent loadEvent) {
                configManager.registerLoadListener((configHolder, configData) -> loadEvent.onLoad(this.getFutureConfig(), (Object)configData));
            }

            public Class<?> getType() {
                return defaultObject.getClass();
            }

            public String getId() {
                return modId;
            }
        });
        for (Field field : defaultObject.getClass().getFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            ConfigValue l = AutoConfigCompat.createConfigValue(ReflectionUtils.get((Object)defaultObject, (Field)field), AutoConfigCompat.isTransitive(field), field.getType(), () -> ReflectionUtils.get((Object)config, (Field)field), s -> ReflectionUtils.set((Object)config, (Object)s, (Field)field));
            if (l == TRANSITIVE) {
                l = AutoConfigCompat.createNestedObjectBased(field.getName(), field.getType(), config);
            }
            builder.set(field.getName(), l);
        }
        Config d = builder.build();
        ConfigIntermediary.configs.put(modId, d);
        return d;
    }

    private static Config createObjectBased(final String modId, @NotNull Object config, final ConfigManager configManager) {
        TransitiveConfigValueBuilder.ConfigBuilder builder = TransitiveConfigValueBuilder.builder((TransitiveConfigValueBuilder.ConfigDelegate)new TransitiveConfigValueBuilder.ConfigDelegate(){
            private final Supplier<Object> a = () -> {
                try {
                    return configManager.getConfigClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };

            public void save() {
                configManager.save();
            }

            public void load() {
                configManager.load();
            }

            public Object getAsDefault() {
                return this.a.get();
            }

            public Object get() {
                return configManager.getConfig();
            }

            public void set(Object val) {
                configManager.setConfig((ConfigData)val);
            }

            public void onSave(SaveEvent saveEvent) {
                configManager.registerSaveListener((configHolder, configData) -> saveEvent.onSave(this.getFutureConfig(), (Object)configData));
            }

            public void onLoad(LoadEvent loadEvent) {
                configManager.registerLoadListener((configHolder, configData) -> loadEvent.onLoad(this.getFutureConfig(), (Object)configData));
            }

            public Class<?> getType() {
                return null;
            }

            public String getId() {
                return modId;
            }
        });
        for (Field field : config.getClass().getFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            ConfigValue l = AutoConfigCompat.createConfigValue(AutoConfigCompat.isTransitive(field), field.getType(), () -> ReflectionUtils.get((Object)config, (Field)field), s -> ReflectionUtils.set((Object)config, (Object)s, (Field)field));
            if (l == TRANSITIVE) {
                l = AutoConfigCompat.createNestedObjectBased(field.getName(), field.getType(), config);
            }
            builder.set(field.getName(), l);
        }
        Config d = builder.build();
        ConfigIntermediary.configs.put(modId, d);
        return d;
    }

    private static ConfigValue createConfigValue(final Object defaultObject, boolean transitive, final Class<?> type, final Supplier<?> getter, final Consumer setter) {
        if (!transitive) {
            if (type.isArray()) {
                return new ArrayConfigValue(){

                    public ConfigValue get(int a) {
                        return AutoConfigCompat.createConfigValue(AutoConfigCompat.isTransitive(this.getType()), this.getType().componentType(), () -> Array.get(this.get(), a), c -> this.set(a, c));
                    }

                    public void set(int a, Object value) {
                        Array.set(this.get(), a, value);
                    }

                    public int size() {
                        return Array.getLength(this.get());
                    }

                    public Object get() {
                        return getter.get();
                    }

                    public Object getDefaultValue() {
                        return defaultObject;
                    }

                    public void resetToDefault() {
                        this.set(defaultObject);
                    }

                    public void set(Object value) {
                        setter.accept(value);
                    }

                    public Class<?> getType() {
                        return type;
                    }
                };
            }
            if (List.class.isAssignableFrom(type)) {
                return new ArrayConfigValue(){

                    public ConfigValue get(int a) {
                        return AutoConfigCompat.createConfigValue(((List)defaultObject).get(a), AutoConfigCompat.isTransitive(this.getType()), ((List)this.getAs(List.class)).get(a).getClass(), () -> this.get(a), s -> this.set(a, s));
                    }

                    public void set(int a, Object value) {
                        this.get(a).set(value);
                    }

                    public int size() {
                        return ((List)this.getAs(List.class)).size();
                    }

                    public Object get() {
                        return getter.get();
                    }

                    public Object getDefaultValue() {
                        return defaultObject;
                    }

                    public void resetToDefault() {
                        this.set(defaultObject);
                    }

                    public void set(Object value) {
                        setter.accept(value);
                    }

                    public Class<?> getType() {
                        return type;
                    }
                };
            }
            return new ObjectConfigValue(){

                public Object get() {
                    return getter.get();
                }

                public Object getDefaultValue() {
                    return defaultObject;
                }

                public void resetToDefault() {
                    this.set(defaultObject);
                }

                public void set(Object value) {
                    setter.accept(value);
                }

                public Class<?> getType() {
                    return type;
                }
            };
        }
        return TRANSITIVE;
    }

    private static ConfigValue createConfigValue(boolean transitive, final Class<?> type, final Supplier<?> getter, final Consumer setter) {
        if (!transitive) {
            if (type.isArray()) {
                return new ArrayConfigValue(){
                    private final Object a = this.get();

                    public ConfigValue get(int a) {
                        return AutoConfigCompat.createConfigValue(AutoConfigCompat.isTransitive(this.getType()), this.getType().componentType(), () -> Array.get(this.get(), a), c -> this.set(a, c));
                    }

                    public void set(int a, Object value) {
                        Array.set(this.get(), a, value);
                    }

                    public int size() {
                        return Array.getLength(this.get());
                    }

                    public Object get() {
                        return getter.get();
                    }

                    public Object getDefaultValue() {
                        return this.a;
                    }

                    public void resetToDefault() {
                        this.set(this.a);
                    }

                    public void set(Object value) {
                        setter.accept(value);
                    }

                    public Class<?> getType() {
                        return type;
                    }
                };
            }
            if (List.class.isAssignableFrom(type)) {
                return new ArrayConfigValue(){
                    private final Object a = this.get();

                    public ConfigValue get(int a) {
                        return AutoConfigCompat.createConfigValue(AutoConfigCompat.isTransitive(this.getType()), ((List)this.getAs(List.class)).get(a).getClass(), () -> this.get(a), s -> this.set(a, s));
                    }

                    public void set(int a, Object value) {
                        this.get(a).set(value);
                    }

                    public int size() {
                        return ((List)this.getAs(List.class)).size();
                    }

                    public Object get() {
                        return getter.get();
                    }

                    public Object getDefaultValue() {
                        return this.a;
                    }

                    public void resetToDefault() {
                        this.set(this.a);
                    }

                    public void set(Object value) {
                        setter.accept(value);
                    }

                    public Class<?> getType() {
                        return type;
                    }
                };
            }
            return new ObjectConfigValue(){
                private final Object a = this.get();

                public Object get() {
                    return getter.get();
                }

                public Object getDefaultValue() {
                    return this.a;
                }

                public void resetToDefault() {
                    this.set(this.a);
                }

                public void set(Object value) {
                    setter.accept(value);
                }

                public Class<?> getType() {
                    return type;
                }
            };
        }
        return TRANSITIVE;
    }

    private static boolean isTransitive(Field field) {
        if (field.isAnnotationPresent(ConfigEntry.Gui.TransitiveObject.class)) {
            return true;
        }
        if (field.isAnnotationPresent(ConfigEntry.Gui.CollapsibleObject.class)) {
            return true;
        }
        if (field.getType().isArray()) {
            return false;
        }
        if (field.getType().isPrimitive()) {
            return false;
        }
        if (field.getType().equals(String.class)) {
            return false;
        }
        if (field.getType().equals(Field.class)) {
            return false;
        }
        if (field.getType().getFields().length == 0) {
            return false;
        }
        return Arrays.stream(field.getType().getFields()).noneMatch(fieldd -> Modifier.isStatic(fieldd.getModifiers()) || Modifier.isFinal(fieldd.getModifiers()));
    }

    private static boolean isTransitive(Class<?> type) {
        if (type.isArray()) {
            return false;
        }
        if (type.isPrimitive()) {
            return false;
        }
        if (type.equals(String.class)) {
            return false;
        }
        if (type.equals(Field.class)) {
            return false;
        }
        if (type.getFields().length == 0) {
            return false;
        }
        return Arrays.stream(type.getFields()).noneMatch(fieldd -> Modifier.isStatic(fieldd.getModifiers()) || Modifier.isFinal(fieldd.getModifiers()));
    }

    private static TransitiveConfigValue createNestedObjectBased(final String objName, final Class<?> type, final Object parent) {
        TransitiveConfigValueBuilder builder = TransitiveConfigValueBuilder.builder((TransitiveConfigValueBuilder.Delegate)new TransitiveConfigValueBuilder.Delegate(){
            private final Object a;
            {
                this.a = ReflectionUtils.get((Object)parent, (Field)ReflectionUtils.get(parent.getClass(), (String)objName));
            }

            public Object getAsDefault() {
                return this.a;
            }

            public Object get() {
                return ReflectionUtils.get((Object)parent, (Field)ReflectionUtils.get(parent.getClass(), (String)objName));
            }

            public void set(Object val) {
                ReflectionUtils.set((Object)parent, (Object)val, (Field)ReflectionUtils.get(parent.getClass(), (String)objName));
            }

            public Class<?> getType() {
                return type;
            }
        });
        for (Field field : builder.delegate.get().getClass().getFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            ConfigValue l = AutoConfigCompat.createConfigValue(AutoConfigCompat.isTransitive(field), field.getType(), () -> ReflectionUtils.get((Object)builder.delegate.get(), (Field)field), s -> ReflectionUtils.set((Object)builder.delegate.get(), (Object)s, (Field)field));
            if (l == TRANSITIVE) {
                l = AutoConfigCompat.createNestedObjectBased(field.getName(), field.getType(), builder.delegate.get());
            }
            builder.set(field.getName(), l);
        }
        return builder.build();
    }
}

