/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.configintermediary.compat.integration;

import com.jab125.configintermediary.api.value.Config;
import com.jab125.configintermediary.api.value.TransitiveConfigValue;
import com.jab125.configintermediary.compat.integration.IntermediaryFolderEntry;
import com.jab125.configintermediary.compat.integration.IntermediaryValue;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.nio.file.Path;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class IntermediaryConfig
implements IModConfig {
    private final Config config;
    private final String id;

    public IntermediaryConfig(Config config) {
        this.config = config;
        this.id = config.getId();
    }

    public IntermediaryConfig(Config config, String id) {
        this.config = config;
        this.id = id;
    }

    public void update(IConfigEntry iConfigEntry) {
        Set changedValues = ConfigHelper.getChangedValues((IConfigEntry)iConfigEntry);
        if (!changedValues.isEmpty()) {
            for (IConfigValue changedValue : changedValues) {
                if (!(changedValue instanceof IntermediaryValue)) continue;
                IntermediaryValue intermediaryValue = (IntermediaryValue)changedValue;
                intermediaryValue.configValue.set(intermediaryValue.get());
            }
            this.config.save();
        }
    }

    public IConfigEntry getRoot() {
        return new IntermediaryFolderEntry((TransitiveConfigValue)this.config);
    }

    public ConfigType getType() {
        return ConfigType.UNIVERSAL;
    }

    public String getFileName() {
        return FabricLoader.getInstance().getModContainer(this.getModId()).isPresent() ? ((ModContainer)FabricLoader.getInstance().getModContainer(this.getModId()).get()).getMetadata().getName() : this.getModId();
    }

    public boolean isChanged() {
        return ConfigHelper.gatherAllConfigValues((IModConfig)this).stream().anyMatch(a -> {
            if (a instanceof IntermediaryValue) {
                IntermediaryValue intermediaryValue = (IntermediaryValue)a;
                return !intermediaryValue.configValue.get().equals(intermediaryValue.configValue.getDefaultValue());
            }
            return false;
        });
    }

    public String getModId() {
        return this.id;
    }

    public void loadWorldConfig(Path path, Consumer<IModConfig> consumer) {
    }

    public void restoreDefaults() {
        for (IConfigValue gatherAllConfigValue : ConfigHelper.gatherAllConfigValues((IModConfig)this)) {
            if (!(gatherAllConfigValue instanceof IntermediaryValue)) continue;
            IntermediaryValue intermediaryValue = (IntermediaryValue)gatherAllConfigValue;
            gatherAllConfigValue.restore();
            intermediaryValue.apply();
        }
        this.config.save();
    }

    public boolean isReadOnly() {
        return false;
    }
}

