/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.configintermediary.config;

import com.jab125.configintermediary.ConfigIntermediary;
import com.jab125.configintermediary.api.entrypoint.ConfigRegistration;
import com.jab125.configintermediary.api.event.LoadEvent;
import com.jab125.configintermediary.api.event.SaveEvent;
import com.jab125.configintermediary.api.value.Config;
import com.jab125.configintermediary.api.value.ConfigValue;
import com.jab125.configintermediary.api.value.ObjectConfigValue;
import com.jab125.configintermediary.compat.TransitiveConfigValueBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;

public class IntermediaryConfiguredConfig
implements ModInitializer {
    public static boolean forceConfiguredMenu = false;
    public static boolean enabled = false;
    private static Properties properties;

    public static void load() throws IOException {
        properties = new Properties();
        if (!FabricLoader.getInstance().getConfigDir().resolve("intermediary-config/configured.properties").toFile().exists()) {
            FabricLoader.getInstance().getConfigDir().resolve("intermediary-config/configured.properties").toFile().getParentFile().mkdirs();
            FabricLoader.getInstance().getConfigDir().resolve("intermediary-config/configured.properties").toFile().createNewFile();
            properties.setProperty("enabled", String.valueOf(false));
            properties.store(Files.newBufferedWriter(FabricLoader.getInstance().getConfigDir().resolve("intermediary-config/configured.properties"), new OpenOption[0]), "Whether to automatically load generate configured config screens.");
        } else {
            properties.load(Files.newBufferedReader(FabricLoader.getInstance().getConfigDir().resolve("intermediary-config/configured.properties")));
        }
        if (properties.containsKey("enabled")) {
            try {
                enabled = Boolean.parseBoolean(properties.getProperty("enabled"));
            }
            catch (Exception e) {
                enabled = false;
            }
        }
    }

    public static void save() throws IOException {
        properties.store(Files.newBufferedWriter(FabricLoader.getInstance().getConfigDir().resolve("intermediary-config/configured.properties"), new OpenOption[0]), "Whether to automatically load generate configured config screens.");
    }

    public void onInitialize() {
        IntermediaryConfiguredConfig.initConfig();
    }

    private static void initConfig() {
        try {
            TransitiveConfigValueBuilder.ConfigBuilder configBuilder = TransitiveConfigValueBuilder.builder((TransitiveConfigValueBuilder.ConfigDelegate)new TransitiveConfigValueBuilder.ConfigDelegate(){

                public void save() {
                    try {
                        IntermediaryConfiguredConfig.save();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                public void load() {
                    try {
                        IntermediaryConfiguredConfig.load();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                public void onLoad(LoadEvent loadEvent) {
                }

                public void onSave(SaveEvent saveEvent) {
                }

                public String getId() {
                    return "config-intermediary-configured";
                }

                public Object getAsDefault() {
                    return null;
                }

                public Object get() {
                    return null;
                }

                public void set(Object val) {
                }

                public Class<?> getType() {
                    return Void.TYPE;
                }

                public void resetConfig() {
                    properties.setProperty("enabled", "false");
                    enabled = false;
                }
            });
            configBuilder.set("enabled", (ConfigValue)new ObjectConfigValue(){

                public Object get() {
                    return Boolean.parseBoolean(properties.getProperty("enabled"));
                }

                public Object getDefaultValue() {
                    return false;
                }

                public void resetToDefault() {
                    properties.setProperty("enabled", "false");
                }

                public void set(Object value) {
                    properties.setProperty("enabled", String.valueOf(value));
                }

                public Class<?> getType() {
                    return Boolean.TYPE;
                }

                public boolean requiresGameRestart() {
                    return true;
                }

                public class_2561 getComment() {
                    return class_2561.method_43470((String)"Whether to generate configuration screens via Configured.");
                }
            });
            Config l = configBuilder.build();
            ConfigIntermediary.configs.put("config-intermediary-configured", l);
            FabricLoader.getInstance().getEntrypoints("config-intermediary:registration", ConfigRegistration.class).forEach(a -> a.onConfigRegistered(l));
            IntermediaryConfiguredConfig.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

