/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.configintermediary.compat;

import com.jab125.configintermediary.ConfigIntermediary;
import com.jab125.configintermediary.api.event.LoadEvent;
import com.jab125.configintermediary.api.event.SaveEvent;
import com.jab125.configintermediary.api.value.Config;
import com.jab125.configintermediary.api.value.ConfigValue;
import com.jab125.configintermediary.api.value.ObjectConfigValue;
import com.jab125.configintermediary.compat.TransitiveConfigValueBuilder;
import com.jab125.configintermediary.mixin.modmenu.EnumConfigOptionAccessor;
import com.jab125.configintermediary.util.ReflectionUtils;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.config.ModMenuConfigManager;
import com.terraformersmc.modmenu.config.option.BooleanConfigOption;
import com.terraformersmc.modmenu.config.option.EnumConfigOption;
import com.terraformersmc.modmenu.config.option.StringSetConfigOption;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Set;

public class ModMenuCompat {
    public static Config register() {
        TransitiveConfigValueBuilder.ConfigBuilder builder = TransitiveConfigValueBuilder.builder((TransitiveConfigValueBuilder.ConfigDelegate)new TransitiveConfigValueBuilder.ConfigDelegate(){

            public void save() {
                ModMenuConfigManager.save();
            }

            public void load() {
                ModMenuConfigManager.initializeConfig();
            }

            public void onLoad(LoadEvent loadEvent) {
            }

            public void onSave(SaveEvent saveEvent) {
            }

            public Object getAsDefault() {
                return null;
            }

            public void resetConfig() {
                for (ConfigValue value : this.getFutureConfig().getAll().values()) {
                    value.resetToDefault();
                }
            }

            public Object get() {
                return null;
            }

            public void set(Object val) {
            }

            public Class<?> getType() {
                return Void.TYPE;
            }

            public String getId() {
                return "modmenu";
            }
        });
        for (Field field : ModMenuConfig.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !BooleanConfigOption.class.isAssignableFrom(field.getType()) && !EnumConfigOption.class.isAssignableFrom(field.getType()) && !StringSetConfigOption.class.isAssignableFrom(field.getType())) continue;
            try {
                builder.set(ModMenuCompat.getConfigKey(field), ModMenuCompat.createConfigValue(field));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        Config l = builder.build();
        ConfigIntermediary.configs.put("modmenu", l);
        return l;
    }

    private static String getConfigKey(Field field) throws IllegalAccessException {
        return switch (ModMenuCompat.asEnum(field.getType())) {
            default -> throw new IncompatibleClassChangeError();
            case ConfigType.BOOLEAN -> ((BooleanConfigOption)field.get(null)).getKey();
            case ConfigType.ENUM -> ((EnumConfigOption)field.get(null)).getKey();
            case ConfigType.STRING_SET -> ((StringSetConfigOption)field.get(null)).getKey();
        };
    }

    private static ConfigValue createConfigValue(final Field field) throws IllegalAccessException {
        return switch (ModMenuCompat.asEnum(field.getType())) {
            default -> throw new IncompatibleClassChangeError();
            case ConfigType.BOOLEAN -> new ObjectConfigValue(){

                public Object get() {
                    try {
                        return ((BooleanConfigOption)field.get(null)).getValue();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }

                public Object getDefaultValue() {
                    return ((BooleanConfigOption)ReflectionUtils.get(null, (Field)field)).getDefaultValue();
                }

                public void resetToDefault() {
                    this.set(this.getDefaultValue());
                }

                public void set(Object value) {
                    try {
                        ((BooleanConfigOption)field.get(null)).setValue(((Boolean)value).booleanValue());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public Class<?> getType() {
                    return Boolean.TYPE;
                }
            };
            case ConfigType.ENUM -> new ObjectConfigValue(){

                public Object get() {
                    try {
                        return ((EnumConfigOption)field.get(null)).getValue();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }

                public Object getDefaultValue() {
                    return ((EnumConfigOption)ReflectionUtils.get(null, (Field)field)).getDefaultValue();
                }

                public void resetToDefault() {
                    this.set(this.getDefaultValue());
                }

                public void set(Object value) {
                    try {
                        ((EnumConfigOption)field.get(null)).setValue((Enum)value);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public Class<?> getType() {
                    try {
                        return ((EnumConfigOptionAccessor)field.get(null)).getEnumClass();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return Enum.class;
                    }
                }
            };
            case ConfigType.STRING_SET -> new ObjectConfigValue(){

                public Object get() {
                    try {
                        return ((StringSetConfigOption)field.get(null)).getValue();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return Set.of();
                    }
                }

                public Object getDefaultValue() {
                    return ((StringSetConfigOption)ReflectionUtils.get(null, (Field)field)).getDefaultValue();
                }

                public void resetToDefault() {
                    this.set(this.getDefaultValue());
                }

                public void set(Object value) {
                    try {
                        ((StringSetConfigOption)field.get(null)).setValue((Set)value);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public Class<?> getType() {
                    return Set.class;
                }
            };
        };
    }

    private static ConfigType asEnum(Class<?> clazz) {
        return Arrays.stream(ConfigType.values()).filter(a -> a.clazz.equals(clazz)).findFirst().get();
    }

    private static enum ConfigType {
        BOOLEAN(BooleanConfigOption.class),
        ENUM(EnumConfigOption.class),
        STRING_SET(StringSetConfigOption.class);

        private final Class<?> clazz;

        private ConfigType(Class<?> clazz) {
            this.clazz = clazz;
        }
    }
}

