/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.configintermediary.compat;

import com.jab125.configintermediary.ConfigIntermediary;
import com.jab125.configintermediary.api.event.LoadEvent;
import com.jab125.configintermediary.api.event.SaveEvent;
import com.jab125.configintermediary.api.value.ArrayConfigValue;
import com.jab125.configintermediary.api.value.Config;
import com.jab125.configintermediary.api.value.ConfigValue;
import com.jab125.configintermediary.api.value.ObjectConfigValue;
import com.jab125.configintermediary.api.value.TransitiveConfigValue;
import com.jab125.configintermediary.compat.TransitiveConfigValueBuilder;
import com.jab125.configintermediary.mixin.owoconfig.ConfigWrapperAccessor;
import com.jab125.configintermediary.mixin.owoconfig.OptionAccessor;
import com.jab125.configintermediary.util.ReflectionUtils;
import io.wispforest.owo.config.ConfigWrapper;
import io.wispforest.owo.config.Option;
import io.wispforest.owo.config.annotation.RestartRequired;
import io.wispforest.owo.util.NumberReflection;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2960;

public class OwoConfigCompat {
    private static final ConfigValue TRANSITIVE = new ConfigValue(){

        public Object get() {
            return null;
        }

        public Object getDefaultValue() {
            return null;
        }

        public void resetToDefault() {
        }

        public void set(Object value) {
        }

        public Class<?> getType() {
            return null;
        }
    };

    public static <T> Config register(final ConfigWrapper<T> wrapper, final Class<T> configClass) {
        TransitiveConfigValueBuilder.ConfigBuilder builder = TransitiveConfigValueBuilder.builder((TransitiveConfigValueBuilder.ConfigDelegate)new TransitiveConfigValueBuilder.ConfigDelegate(){

            public void save() {
                wrapper.save();
            }

            public void load() {
                wrapper.load();
            }

            public void onLoad(LoadEvent loadEvent) {
            }

            public void onSave(SaveEvent saveEvent) {
            }

            public String getId() {
                return wrapper.name();
            }

            public Object getAsDefault() {
                try {
                    return configClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public Object get() {
                Object d = ((ConfigWrapperAccessor)wrapper).getInstance();
                System.out.println("d: " + d.getClass());
                return d;
            }

            public void set(Object val) {
                ((ConfigWrapperAccessor)wrapper).setInstance(val);
            }

            public Class<?> getType() {
                return configClass;
            }
        });
        wrapper.allOptions().forEach((key, option) -> {
            ConfigValue l = OwoConfigCompat.createConfigValue(option);
            if (l == TRANSITIVE) {
                l = OwoConfigCompat.createNestedObjectBased(key.name(), option.clazz(), ((ConfigWrapperAccessor)wrapper).getInstance());
            }
            builder.set(key.name(), l);
        });
        Config l = builder.build();
        ConfigIntermediary.configs.put(wrapper.name(), l);
        return l;
    }

    private static <T> ConfigValue createConfigValue(final Option<T> option) {
        boolean transitive = OwoConfigCompat.isTransitive(option);
        final Class type = option.clazz();
        if (!transitive) {
            if (type.isArray()) {
                return new ArrayConfigValue(){

                    public ConfigValue get(int a) {
                        return OwoConfigCompat.createConfigValue(OwoConfigCompat.isTransitive(this.getType()), this.getType().componentType(), () -> Array.get(this.get(), a), c -> this.set(a, c));
                    }

                    public boolean requiresGameRestart() {
                        return ((OptionAccessor)option).getBackingField().hasAnnotation(RestartRequired.class);
                    }

                    public void set(int a, Object value) {
                        Array.set(this.get(), a, value);
                    }

                    public int size() {
                        return Array.getLength(this.get());
                    }

                    public Object get() {
                        return option.value();
                    }

                    public Object getDefaultValue() {
                        return option.defaultValue();
                    }

                    public void resetToDefault() {
                        this.set(this.getDefaultValue());
                    }

                    public void set(Object value) {
                        option.set(value);
                    }

                    public Class<?> getType() {
                        return type;
                    }
                };
            }
            if (List.class.isAssignableFrom(type)) {
                return new ArrayConfigValue(){

                    public ConfigValue get(int a) {
                        return OwoConfigCompat.createConfigValue(OwoConfigCompat.isTransitive(this.getType()), ((List)this.getAs(List.class)).get(a).getClass(), () -> this.get(a), s -> this.set(a, s));
                    }

                    public void set(int a, Object value) {
                        this.get(a).set(value);
                    }

                    public int size() {
                        return ((List)this.getAs(List.class)).size();
                    }

                    public Object get() {
                        return option.value();
                    }

                    public void set(Object value) {
                        option.set(value);
                    }

                    public Class<?> getType() {
                        return type;
                    }

                    public Object getDefaultValue() {
                        return option.defaultValue();
                    }

                    public boolean requiresGameRestart() {
                        return ((OptionAccessor)option).getBackingField().hasAnnotation(RestartRequired.class);
                    }

                    public void resetToDefault() {
                        this.set(this.getDefaultValue());
                    }
                };
            }
            return new ObjectConfigValue(){
                private final Object default_ = this.get();

                public Object get() {
                    return option.value();
                }

                public boolean requiresGameRestart() {
                    return ((OptionAccessor)option).getBackingField().hasAnnotation(RestartRequired.class);
                }

                public void set(Object value) {
                    option.set(value);
                }

                public Class<?> getType() {
                    return type;
                }

                public Object getDefaultValue() {
                    return this.default_;
                }

                public void resetToDefault() {
                    this.set(this.getDefaultValue());
                }
            };
        }
        return TRANSITIVE;
    }

    private static boolean isTransitive(Option<?> option) {
        Class clazz = option.clazz();
        if (clazz.isArray()) {
            return false;
        }
        if (NumberReflection.isNumberType((Class)clazz)) {
            return false;
        }
        if (String.class.isAssignableFrom(option.clazz())) {
            return false;
        }
        if (class_2960.class.isAssignableFrom(option.clazz())) {
            return false;
        }
        if (Enum.class.isAssignableFrom(option.clazz())) {
            return false;
        }
        return !List.class.isAssignableFrom(option.clazz());
    }

    private static boolean isTransitive(Field field) {
        Class<?> clazz = field.getType();
        if (clazz.isArray()) {
            return false;
        }
        if (NumberReflection.isNumberType(clazz)) {
            return false;
        }
        if (String.class.isAssignableFrom(field.getType())) {
            return false;
        }
        if (class_2960.class.isAssignableFrom(field.getType())) {
            return false;
        }
        if (Enum.class.isAssignableFrom(field.getType())) {
            return false;
        }
        return !List.class.isAssignableFrom(field.getType());
    }

    private static boolean isTransitive(Class<?> clazz) {
        if (clazz.isArray()) {
            return false;
        }
        if (NumberReflection.isNumberType(clazz)) {
            return false;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (class_2960.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return false;
        }
        return !List.class.isAssignableFrom(clazz);
    }

    private static ConfigValue createConfigValue(boolean transitive, final Class<?> type, final Supplier<?> getter, final Consumer setter) {
        if (!transitive) {
            if (type.isArray()) {
                return new ArrayConfigValue(){
                    private final Object default_ = this.get();

                    public ConfigValue get(int a) {
                        return OwoConfigCompat.createConfigValue(OwoConfigCompat.isTransitive(this.getType()), this.getType().componentType(), () -> Array.get(this.get(), a), c -> this.set(a, c));
                    }

                    public void set(int a, Object value) {
                        Array.set(this.get(), a, value);
                    }

                    public int size() {
                        return Array.getLength(this.get());
                    }

                    public Object get() {
                        return getter.get();
                    }

                    public Object getDefaultValue() {
                        return this.default_;
                    }

                    public void resetToDefault() {
                        this.set(this.getDefaultValue());
                    }

                    public void set(Object value) {
                        setter.accept(value);
                    }

                    public Class<?> getType() {
                        return type;
                    }
                };
            }
            if (List.class.isAssignableFrom(type)) {
                return new ArrayConfigValue(){
                    private final Object default_ = this.get();

                    public ConfigValue get(int a) {
                        return OwoConfigCompat.createConfigValue(OwoConfigCompat.isTransitive(this.getType()), ((List)this.getAs(List.class)).get(a).getClass(), () -> this.get(a), s -> this.set(a, s));
                    }

                    public void set(int a, Object value) {
                        this.get(a).set(value);
                    }

                    public int size() {
                        return ((List)this.getAs(List.class)).size();
                    }

                    public Object get() {
                        return getter.get();
                    }

                    public void set(Object value) {
                        setter.accept(value);
                    }

                    public Class<?> getType() {
                        return type;
                    }

                    public Object getDefaultValue() {
                        return this.default_;
                    }

                    public void resetToDefault() {
                        this.set(this.getDefaultValue());
                    }
                };
            }
            return new ObjectConfigValue(){
                private final Object default_ = this.get();

                public Object get() {
                    return getter.get();
                }

                public void set(Object value) {
                    setter.accept(value);
                }

                public Class<?> getType() {
                    return type;
                }

                public Object getDefaultValue() {
                    return this.default_;
                }

                public void resetToDefault() {
                    this.set(this.getDefaultValue());
                }
            };
        }
        return TRANSITIVE;
    }

    private static TransitiveConfigValue createNestedObjectBased(final String objName, final Class<?> type, final Object parent) {
        TransitiveConfigValueBuilder builder = TransitiveConfigValueBuilder.builder((TransitiveConfigValueBuilder.Delegate)new TransitiveConfigValueBuilder.Delegate(){
            private final Object f = this.get();

            public Object get() {
                return ReflectionUtils.get((Object)parent, (Field)ReflectionUtils.get(parent.getClass(), (String)objName));
            }

            public void set(Object val) {
                ReflectionUtils.set((Object)parent, (Object)val, (Field)ReflectionUtils.get(parent.getClass(), (String)objName));
            }

            public Class<?> getType() {
                return type;
            }

            public Object getAsDefault() {
                return this.f;
            }
        });
        for (Field field : builder.delegate.get().getClass().getFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            ConfigValue l = OwoConfigCompat.createConfigValue(OwoConfigCompat.isTransitive(field), field.getType(), () -> ReflectionUtils.get((Object)builder.delegate.get(), (Field)field), s -> ReflectionUtils.set((Object)builder.delegate.get(), (Object)s, (Field)field));
            if (l == TRANSITIVE) {
                l = OwoConfigCompat.createNestedObjectBased(field.getName(), field.getType(), builder.delegate.get());
            }
            builder.set(field.getName(), l);
        }
        return builder.build();
    }
}

