/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.diff.impl;

import com.jab125.diff.api.DiffApi;
import com.jab125.diff.impl.DiffInfo;
import com.jab125.diff.impl.DiffInfoBundle;
import com.jab125.diff.impl.DiffInfoSimplifier;
import com.jab125.diff.impl.Lengthable;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class DiffApiImpl
implements DiffApi {
    @Override
    public String diffStrings(String stringA, String stringB) {
        return this.diffStrings(stringA, stringB, "a", "b");
    }

    private String diffStrings(String a, String b, String aN, String bN) {
        List<DiffInfo> diffList = this.algorithm(a.replaceAll("\r\n", "\n").split("\n"), b.replaceAll("\r\n", "\n").split("\n"));
        System.out.println(diffList);
        Object sBuilder = "";
        sBuilder = (String)sBuilder + String.format("--- %s\n+++ %s\n", aN, bN);
        for (DiffInfoBundle diffInfos : DiffInfoSimplifier.simplify(diffList)) {
            sBuilder = (String)sBuilder + diffInfos.toFancyString();
        }
        return ((String)sBuilder).substring(0, ((String)sBuilder).length() - 1);
    }

    @Override
    public String diffFiles(Path fileA, Path fileB) {
        try {
            return this.diffStrings(Files.readString(fileA), Files.readString(fileB), fileA.toString(), fileB.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String diffFiles(Path fileA, Path fileB, String a, String b) {
        try {
            return this.diffStrings(Files.readString(fileA), Files.readString(fileB), a, b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Path> collectFilesRecursively(Path directory) throws IOException {
        ArrayList<Path> fileList = new ArrayList<Path>();
        Files.walk(directory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(fileList::add);
        return fileList;
    }

    @Override
    public void diffDirectories(Path dirA, Path dirB, Path output) {
        try {
            List<Path> dirAFiles = DiffApiImpl.collectFilesRecursively(dirA);
            List<Path> dirBFiles = DiffApiImpl.collectFilesRecursively(dirB);
            ArrayList<Path> dirARelative = new ArrayList<Path>();
            ArrayList<Path> dirBRelative = new ArrayList<Path>();
            for (Path dirAFile : dirAFiles) {
                dirARelative.add(dirA.relativize(dirAFile));
            }
            for (Path dirBFile : dirBFiles) {
                dirBRelative.add(dirB.relativize(dirBFile));
            }
            List<Path> bNotContain = dirARelative.stream().filter(o -> !dirBRelative.contains(o)).toList();
            List<Path> aNotContain = dirBRelative.stream().filter(o -> !dirARelative.contains(o)).toList();
            List<Path> allContain = dirBRelative.stream().filter(dirARelative::contains).toList();
            for (Path path : allContain) {
                if (!path.toString().endsWith(".java")) continue;
                String diff = this.diffFiles(dirA.resolve(path), dirB.resolve(path), "a/" + path, "b/" + path);
                Path outputPath = output.resolve(path + ".patch");
                outputPath.toFile().getParentFile().mkdirs();
                Files.writeString(outputPath, (CharSequence)diff, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int lcsLength(String a, String b) {
        int i;
        int m = a.length();
        int n = b.length();
        int[][] C = new int[m + 1][n + 1];
        for (i = 0; i <= m; ++i) {
            C[i][0] = 0;
        }
        for (int j = 0; j <= n; ++j) {
            C[0][j] = 0;
        }
        for (i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                C[i][j] = a.charAt(i - 1) == b.charAt(j - 1) ? C[i - 1][j - 1] + 1 : Math.max(C[i][j - 1], C[i - 1][j]);
            }
        }
        return C[m][n];
    }

    public static int lcsLength(String[] a, String[] b) {
        int i;
        int m = a.length;
        int n = b.length;
        int[][] C = new int[m + 1][n + 1];
        for (i = 0; i <= m; ++i) {
            C[i][0] = 0;
        }
        for (int j = 0; j <= n; ++j) {
            C[0][j] = 0;
        }
        for (i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                C[i][j] = Objects.equals(a[i - 1], b[j - 1]) ? C[i - 1][j - 1] + 1 : Math.max(C[i][j - 1], C[i - 1][j]);
            }
        }
        return C[m][n];
    }

    private List<DiffInfo> algorithm(final String[] A, final String[] B) {
        Lengthable aLengthable = new Lengthable(){

            @Override
            public int getSize() {
                return A.length;
            }

            @Override
            public Object getElemOf(int i) {
                return A[i - 1];
            }
        };
        Lengthable bLengthable = new Lengthable(){

            @Override
            public int getSize() {
                return B.length;
            }

            @Override
            public Object getElemOf(int i) {
                return B[i - 1];
            }
        };
        int[][] C = this.algorithm(aLengthable, bLengthable);
        return this.backtrack(C, aLengthable, bLengthable, aLengthable.size(), bLengthable.size());
    }

    public static void main(String[] args) {
        DiffApiImpl impl = new DiffApiImpl();
    }

    private int[][] algorithm(Lengthable A, Lengthable B) {
        int[][] P = new int[A.size() + 1][B.size() + 1];
        for (int i = 0; i <= A.length(); ++i) {
            for (int j = 0; j <= B.length(); ++j) {
                if (i == 0 || j == 0) {
                    P[i][j] = 0;
                    continue;
                }
                if (Objects.equals(A.getElemOf(i), B.getElemOf(j))) {
                    P[i][j] = 1 + P[i - 1][j - 1];
                    continue;
                }
                if (Objects.equals(A.getElemOf(i), B.getElemOf(j))) continue;
                P[i][j] = Math.max(P[i - 1][j], P[i][j - 1]);
            }
        }
        return P;
    }

    private List<DiffInfo> backtrack(int[][] C, Lengthable X, Lengthable Y, int i, int j) {
        if (i > 0 && j > 0 && Objects.equals(X.getElemOf(i), Y.getElemOf(j))) {
            List<DiffInfo> result = this.backtrack(C, X, Y, i - 1, j - 1);
            ArrayList<DiffInfo> objects = new ArrayList<DiffInfo>(result);
            objects.add(new DiffInfo(X.getElemOf(i), i, j, DiffInfo.Type.UNCHANGED));
            return objects;
        }
        if (j > 0 && (i == 0 || C[i][j - 1] >= C[i - 1][j])) {
            List<DiffInfo> result = this.backtrack(C, X, Y, i, j - 1);
            ArrayList<DiffInfo> objects = new ArrayList<DiffInfo>(result);
            objects.add(new DiffInfo(Y.getElemOf(j), i, j, DiffInfo.Type.ADDITION));
            return objects;
        }
        if (i > 0 && (j == 0 || C[i][j - 1] < C[i - 1][j])) {
            List<DiffInfo> result = this.backtrack(C, X, Y, i - 1, j);
            ArrayList<DiffInfo> objects = new ArrayList<DiffInfo>(result);
            objects.add(new DiffInfo(X.getElemOf(i), i, j, DiffInfo.Type.DELETION));
            return objects;
        }
        return List.of();
    }
}

