/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.diff.impl;

import com.jab125.diff.impl.DiffInfo;
import java.util.ArrayList;

class DiffInfoBundle
extends ArrayList<DiffInfo> {
    DiffInfo firstDiffInfo;
    private DiffInfo prevDiffInfo;
    int additions;
    int removals;

    DiffInfoBundle() {
    }

    @Override
    public boolean add(DiffInfo diffInfo) {
        if (diffInfo.type() == DiffInfo.Type.ADDITION) {
            ++this.additions;
        } else if (diffInfo.type() == DiffInfo.Type.DELETION) {
            ++this.removals;
        }
        if (this.prevDiffInfo == null) {
            this.firstDiffInfo = diffInfo;
        }
        this.prevDiffInfo = diffInfo;
        return super.add(diffInfo);
    }

    public DiffInfo prev() {
        return this.prevDiffInfo;
    }

    public String toFancyString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@@ -").append(this.firstDiffInfo.lineNumberA()).append(",").append(this.removals).append(" +").append(this.firstDiffInfo.lineNumberB()).append(",").append(this.additions).append(" @@\n");
        for (DiffInfo diffInfo : this) {
            String diffString = diffInfo.type().toString() + diffInfo.object();
            stringBuilder.append(diffString + "\n");
        }
        return stringBuilder.toString();
    }
}

