/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.patch.impl;

import com.jab125.patch.api.PatchApi;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public final class PatchApiImpl
implements PatchApi {
    @Override
    public String patchString(String a, String patch) {
        patch = patch.replaceAll("\r\n", "\n");
        a = a.replaceAll("\r\n", "\n");
        String[] patchLines = patch.split("\n");
        String[] originalLines = a.split("\n");
        ArrayList<String> stringList = new ArrayList<String>();
        int j = 1;
        for (String originalLine : originalLines) {
            stringList.add(originalLine);
            ++j;
        }
        String originalFileName = patchLines[0];
        String patchedFileName = patchLines[1];
        int originalLineNumber = 0;
        int patchedLineNumber = 0;
        int offset = 0;
        for (int i = 1; i < patchLines.length - 1; ++i) {
            String line = patchLines[i + 1];
            System.out.println("line: " + line);
            if (line.startsWith("@@")) {
                String cropped1 = line.substring(4);
                int indexOfSpace = cropped1.indexOf(" ");
                String cropped2 = cropped1.substring(0, indexOfSpace);
                String cropped3 = cropped1.substring(indexOfSpace + 2);
                int indexofAt = cropped3.indexOf("@");
                String cropped4 = cropped3.substring(0, indexofAt);
                System.out.println(cropped4);
                String[] split1 = cropped2.split(",");
                String[] split2 = cropped4.split(",");
                int originalLine = Integer.parseInt(split1[0]);
                int patchedLine = Integer.parseInt(split2[0]);
                offset = 0;
                originalLineNumber = originalLine;
                patchedLineNumber = patchedLine;
            } else if (!line.startsWith(" ")) {
                if (line.startsWith("+")) {
                    stringList.add(patchedLineNumber - 1 + offset, line.substring(1));
                    ++patchedLineNumber;
                } else if (line.startsWith("-")) {
                    System.out.println(patchedLineNumber + " " + line);
                    stringList.remove(patchedLineNumber);
                    offset = 1;
                }
            }
            ++originalLineNumber;
        }
        for (String s : stringList) {
            System.out.println(s);
        }
        return String.join((CharSequence)"\n", stringList);
    }

    @Override
    public String patchFile(Path path, Path patch) {
        try {
            return this.patchString(Files.readString(path), Files.readString(patch));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String patchFile(Path path, String patch) {
        try {
            return this.patchString(Files.readString(path), patch);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Path> collectFilesRecursively(Path directory) throws IOException {
        ArrayList<Path> fileList = new ArrayList<Path>();
        Files.walk(directory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(fileList::add);
        return fileList;
    }

    @Override
    public void patchDirectory(Path original, Path patches, Path output) {
        List<Path> originalFiles = null;
        try {
            originalFiles = PatchApiImpl.collectFilesRecursively(original);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List<Path> patchFiles = null;
        try {
            patchFiles = PatchApiImpl.collectFilesRecursively(patches);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArrayList<Path> dirARelative = new ArrayList<Path>();
        ArrayList<Path> dirBRelative = new ArrayList<Path>();
        for (Path dirAFile : originalFiles) {
            dirARelative.add(original.relativize(dirAFile));
        }
        for (Path dirBFile : patchFiles) {
            dirBRelative.add(patches.relativize(dirBFile));
        }
        List<Path> mutualContain = dirARelative.stream().filter(o -> {
            Object oFileName = o.getFileName().toString();
            oFileName = (String)oFileName + ".patch";
            return dirBRelative.contains(o.resolveSibling((String)oFileName));
        }).toList();
        for (Path path : mutualContain) {
            Path outputPath = output.resolve(path);
            outputPath.toFile().getParentFile().mkdirs();
            try {
                Files.writeString(outputPath, (CharSequence)this.patchFile(original.resolve(path), patches.resolve(path.resolveSibling(path.getFileName() + ".patch"))), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

