/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.decompiler;

import com.jab125.mccustom.constants.Constants;
import com.jab125.mcdl.MinecraftDownloader;
import com.jab125.remapper.Remapper;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.benf.cfr.reader.Main;

public class Decompiler {
    public static String YARN = MinecraftDownloader.VERSION + "+build.1";

    public static void main(String[] args) throws IOException {
        Constants.ROOT.resolve("minecraft/cfr/decompiled").toFile().mkdirs();
        Remapper.remapJarToIntermediary(MinecraftDownloader.VERSION);
        Remapper.remapJarToYarn(MinecraftDownloader.VERSION, YARN);
        Files.copy(Constants.ROOT.resolve("minecraft/.install/client-named.jar"), Constants.ROOT.resolve("minecraft/.install/remapped.jar"), StandardCopyOption.REPLACE_EXISTING);
        if (!Constants.ROOT.resolve("minecraft/cfr/decompiled/summary.txt").toFile().exists()) {
            Main.main(new String[]{Constants.ROOT.resolve("minecraft/.install/remapped.jar").toAbsolutePath().toString(), "--outputdir", Constants.ROOT.resolve("minecraft/cfr/decompiled").toAbsolutePath().toString()});
        }
        Decompiler.setupMcp();
    }

    private static void setupMcp() throws IOException {
        ZipFile zipFile = new ZipFile("minecraft/.install/remapped.jar");
        Iterator<? extends ZipEntry> zipIt = zipFile.entries().asIterator();
        Path zipolk = Files.createTempFile(null, ".zip", new FileAttribute[0]);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipolk.toFile()));
        while (zipIt.hasNext()) {
            ZipEntry entry = zipIt.next();
            ArrayList<String> toBePatched = new ArrayList<String>();
            Decompiler.addToList(toBePatched);
            if (entry.getName().endsWith(".class") && toBePatched.contains(entry.getName().substring(0, entry.getName().length() - 6))) {
                String s1;
                System.out.println("skipping over patched class :)");
                System.out.println("copying over MCP'd class file");
                String s = entry.getName().substring(0, entry.getName().length() - 6);
                Path to = Constants.ROOT.resolve("minecraft/src/patches/" + s + ".java");
                if (!to.toFile().exists()) {
                    to.getParent().toFile().mkdirs();
                    s1 = Files.readString(Constants.ROOT.resolve("minecraft/cfr/decompiled/" + s + ".java"));
                    Files.writeString(to, (CharSequence)s1, StandardCharsets.UTF_8, new OpenOption[0]);
                }
                to = Constants.ROOT.resolve("minecraft/mcpatty/original/" + s + ".java");
                if (to.toFile().exists()) continue;
                to.getParent().toFile().mkdirs();
                s1 = Files.readString(Constants.ROOT.resolve("minecraft/cfr/decompiled/" + s + ".java"));
                Files.writeString(to, (CharSequence)s1, StandardCharsets.UTF_8, new OpenOption[0]);
                continue;
            }
            System.out.println("no");
            ZipEntry a = new ZipEntry(entry.getName());
            out.putNextEntry(a);
            out.write(zipFile.getInputStream(entry).readAllBytes());
            out.closeEntry();
        }
        zipFile.close();
        out.close();
        Constants.ROOT.resolve("minecraft/mcp").toFile().mkdirs();
        Files.copy(zipolk, Constants.ROOT.resolve("minecraft/mcp/mcp.jar"), StandardCopyOption.REPLACE_EXISTING);
    }

    private static void addToList(ArrayList<String> toBePatched) {
        toBePatched.addAll(Constants.toBePatched);
    }
}

