/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.dependency;

import com.jab125.mccustom.constants.Constants;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public class Dependency {
    private final String path;
    private final Path backingPath;
    private final Resolver resolver;

    public Dependency(String path, Resolver resolver) {
        this.path = path;
        this.backingPath = Constants.ROOT.resolve("cache").resolve(this.path);
        this.resolver = resolver;
    }

    public Dependency(Path path, Resolver resolver) {
        this.path = path.toString();
        this.backingPath = path;
        this.resolver = resolver;
    }

    public Path getPath() {
        return this.backingPath;
    }

    public File getFile() {
        return this.backingPath.toFile();
    }

    public Path getResolvedPath() {
        this.lazyResolve();
        return this.backingPath;
    }

    public File getResolvedFile() {
        this.lazyResolve();
        return this.backingPath.toFile();
    }

    public byte[] getBytes() {
        this.lazyResolve();
        try {
            return Files.readAllBytes(this.backingPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getString() {
        this.lazyResolve();
        try {
            return Files.readString(this.backingPath, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean lazyResolve() {
        if (!this.exists()) {
            this.resolve();
            return false;
        }
        return true;
    }

    private void resolve() {
        long time = System.currentTimeMillis();
        this.mkdirs();
        try {
            this.resolver.resolve(this);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        System.out.println("Resolved " + this.path + " in " + (System.currentTimeMillis() - time) + "ms.");
    }

    public boolean exists() {
        return this.backingPath.toFile().exists();
    }

    protected void mkdirs() {
        this.backingPath.toFile().getParentFile().mkdirs();
    }

    public static interface Resolver {
        public void resolve(Dependency var1) throws Throwable;
    }
}

