/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.remapper;

import com.jab125.mccustom.constants.Constants;
import com.jab125.mcdl.MinecraftDownloader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiConsumer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.fabricmc.tinyremapper.IMappingProvider;
import net.fabricmc.tinyremapper.NonClassCopyMode;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.TinyUtils;

public class Remapper {
    public static void main(String[] args) throws IOException {
        String mcVer = MinecraftDownloader.VERSION;
        Remapper.remapJarToIntermediary(mcVer);
        Remapper.remapJarToYarn(mcVer, mcVer + "+build.1");
    }

    public static void remapJarToIntermediary(String version) throws IOException {
        Path versionDir = Constants.ROOT.resolve("minecraft/.install");
        Path intermediaryMappings = versionDir.resolve("intermediary.tiny");
        byte[] intermediaryBytes = Remapper.downloadIntermediary(version);
        Files.write(intermediaryMappings, intermediaryBytes, StandardOpenOption.CREATE);
        Path jarFilePath = versionDir.resolve("client.jar");
        IMappingProvider mappingProvider = TinyUtils.createTinyMappingProvider((Path)versionDir.resolve("intermediary.tiny"), (String)"official", (String)"intermediary");
        TinyRemapper remapper = TinyRemapper.newRemapper().withMappings(mappingProvider).fixPackageAccess(true).rebuildSourceFilenames(true).threads(5).build();
        Path clientJarLoc = jarFilePath;
        try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(versionDir.resolve("client-intermediary.jar")).build();){
            outputConsumer.addNonClassFiles(clientJarLoc, NonClassCopyMode.FIX_META_INF, remapper);
            remapper.readInputs(new Path[]{clientJarLoc});
            remapper.readClassPath(new Path[]{clientJarLoc});
            remapper.readClassPath(new Path[]{Constants.ROOT.resolve("minecraft/.install/libraries")});
            remapper.apply((BiConsumer)outputConsumer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            remapper.finish();
        }
    }

    public static void remapJarToYarn(String version, String yarn) throws IOException {
        Path versionDir = Constants.ROOT.resolve("minecraft/.install");
        Path intermediaryMappings = versionDir.resolve("yarn.tiny");
        byte[] yarnBytes = Remapper.downloadYarn(yarn);
        Files.write(intermediaryMappings, yarnBytes, StandardOpenOption.CREATE);
        Path jarFilePath = versionDir.resolve("client-intermediary.jar");
        IMappingProvider mappingProvider = TinyUtils.createTinyMappingProvider((Path)versionDir.resolve("yarn.tiny"), (String)"intermediary", (String)"named");
        TinyRemapper remapper = TinyRemapper.newRemapper().withMappings(mappingProvider).fixPackageAccess(true).rebuildSourceFilenames(true).threads(5).build();
        Path clientJarLoc = jarFilePath;
        try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(versionDir.resolve("client-named.jar")).build();){
            outputConsumer.addNonClassFiles(clientJarLoc, NonClassCopyMode.FIX_META_INF, remapper);
            remapper.readInputs(new Path[]{clientJarLoc});
            remapper.readClassPath(new Path[]{clientJarLoc});
            remapper.readClassPath(new Path[]{Constants.ROOT.resolve("minecraft/.install/libraries")});
            remapper.apply((BiConsumer)outputConsumer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            remapper.finish();
        }
    }

    public static void remapJarFromYarnToIntermediary(String version, String yarn) throws IOException {
        Path versionDir = Constants.ROOT.resolve("minecraft/.install");
        Path intermediaryMappings = versionDir.resolve("yarn.tiny");
        byte[] yarnBytes = Remapper.downloadYarn(yarn);
        Files.write(intermediaryMappings, yarnBytes, StandardOpenOption.CREATE);
        Path jarFilePath = versionDir.resolve("client-patched-yarn.jar");
        IMappingProvider mappingProvider = TinyUtils.createTinyMappingProvider((Path)versionDir.resolve("yarn.tiny"), (String)"named", (String)"intermediary");
        TinyRemapper remapper = TinyRemapper.newRemapper().withMappings(mappingProvider).fixPackageAccess(true).rebuildSourceFilenames(true).threads(5).build();
        Path clientJarLoc = jarFilePath;
        try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(versionDir.resolve("client-patched-intermediary.jar")).build();){
            outputConsumer.addNonClassFiles(clientJarLoc, NonClassCopyMode.FIX_META_INF, remapper);
            remapper.readInputs(new Path[]{clientJarLoc});
            remapper.readClassPath(new Path[]{clientJarLoc});
            remapper.readClassPath(new Path[]{Constants.ROOT.resolve("minecraft/.install/libraries")});
            remapper.apply((BiConsumer)outputConsumer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            remapper.finish();
        }
    }

    public static void remapJarFromIntermediaryToOfficial(String version) throws IOException {
        Path versionDir = Constants.ROOT.resolve("minecraft/.install");
        Path intermediaryMappings = versionDir.resolve("intermediary.tiny");
        byte[] intermediaryBytes = Remapper.downloadIntermediary(version);
        Files.write(intermediaryMappings, intermediaryBytes, StandardOpenOption.CREATE);
        Path jarFilePath = versionDir.resolve("client-patched-intermediary.jar");
        IMappingProvider mappingProvider = TinyUtils.createTinyMappingProvider((Path)versionDir.resolve("intermediary.tiny"), (String)"intermediary", (String)"official");
        TinyRemapper remapper = TinyRemapper.newRemapper().withMappings(mappingProvider).fixPackageAccess(true).rebuildSourceFilenames(true).threads(5).build();
        Path clientJarLoc = jarFilePath;
        try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(versionDir.resolve("client-patched-official.jar")).build();){
            outputConsumer.addNonClassFiles(clientJarLoc, NonClassCopyMode.FIX_META_INF, remapper);
            remapper.readInputs(new Path[]{clientJarLoc});
            remapper.readClassPath(new Path[]{clientJarLoc});
            remapper.readClassPath(new Path[]{Constants.ROOT.resolve("minecraft/.install/libraries")});
            remapper.apply((BiConsumer)outputConsumer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            remapper.finish();
        }
    }

    private static byte[] downloadIntermediary(String version) throws IOException {
        String url = "https://maven.fabricmc.net/net/fabricmc/intermediary/" + version + "/intermediary-" + version + "-v2.jar";
        byte[] bytes = new URL(url).openStream().readAllBytes();
        Path intermediaryJarPath = Files.createTempFile(null, ".jar", new FileAttribute[0]);
        Files.write(intermediaryJarPath, bytes, new OpenOption[0]);
        JarFile jarFile = new JarFile(intermediaryJarPath.toFile());
        ZipEntry mappings = jarFile.getEntry("mappings/mappings.tiny");
        InputStream df = jarFile.getInputStream(mappings);
        byte[] byts = df.readAllBytes();
        df.close();
        return byts;
    }

    private static byte[] downloadYarn(String version) throws IOException {
        String url = "https://maven.fabricmc.net/net/fabricmc/yarn/" + version + "/yarn-" + version + ".jar";
        url.replace("+", "%2B");
        byte[] bytes = new URL(url).openStream().readAllBytes();
        Path intermediaryJarPath = Files.createTempFile(null, ".jar", new FileAttribute[0]);
        Files.write(intermediaryJarPath, bytes, new OpenOption[0]);
        JarFile jarFile = new JarFile(intermediaryJarPath.toFile());
        ZipEntry mappings = jarFile.getEntry("mappings/mappings.tiny");
        InputStream df = jarFile.getInputStream(mappings);
        byte[] byts = df.readAllBytes();
        df.close();
        return byts;
    }
}

