/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.remapper;

import com.jab125.dependency.Dependency;
import com.jab125.dependency.DependencyUtilities;
import com.jab125.mcdl.MinecraftDownloader2;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.fabricmc.tinyremapper.IMappingProvider;
import net.fabricmc.tinyremapper.NonClassCopyMode;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.TinyUtils;

public class Remapper2 {
    private final MinecraftDownloader2 MINECRAFT_DOWNLOADER;
    public final Dependency INTERMEDIARY_FILE_JAR;
    public final Dependency INTERMEDIARY;
    public final Dependency INTERMEDIARY_JAR;
    public final Dependency YARN_FILE_JAR;
    public final Dependency YARN;
    public final Dependency YARN_JAR;
    private final String yarnVersion;

    public Remapper2(MinecraftDownloader2 minecraftDownloader, String yarnVersion) {
        this.yarnVersion = yarnVersion;
        this.MINECRAFT_DOWNLOADER = minecraftDownloader;
        this.INTERMEDIARY_FILE_JAR = new Dependency("minecraft/" + minecraftDownloader.version + "/intermediary.jar", DependencyUtilities.download("https://maven.fabricmc.net/net/fabricmc/intermediary/" + minecraftDownloader.version + "/intermediary-" + minecraftDownloader.version + "-v2.jar"));
        this.INTERMEDIARY = new Dependency("minecraft/" + minecraftDownloader.version + "/intermediary.tiny", dependency -> {
            JarFile jarFile = new JarFile(this.INTERMEDIARY_FILE_JAR.getResolvedFile());
            ZipEntry mappings = jarFile.getEntry("mappings/mappings.tiny");
            InputStream inputStream = jarFile.getInputStream(mappings);
            byte[] bytes = inputStream.readAllBytes();
            inputStream.close();
            Files.write(dependency.getPath(), bytes, new OpenOption[0]);
        });
        this.INTERMEDIARY_JAR = new Dependency("minecraft/" + minecraftDownloader.version + "/" + minecraftDownloader.version + "-intermediary.jar", dependency -> {
            IMappingProvider mappingProvider = TinyUtils.createTinyMappingProvider((Path)this.INTERMEDIARY.getResolvedPath(), (String)"official", (String)"intermediary");
            TinyRemapper remapper = TinyRemapper.newRemapper().withMappings(mappingProvider).fixPackageAccess(true).rebuildSourceFilenames(true).threads(5).build();
            Path clientJarLoc = minecraftDownloader.MINECRAFT_CLIENT.getResolvedPath();
            try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(dependency.getPath()).build();){
                outputConsumer.addNonClassFiles(clientJarLoc, NonClassCopyMode.FIX_META_INF, remapper);
                remapper.readInputs(new Path[]{clientJarLoc});
                remapper.readClassPath(new Path[]{clientJarLoc});
                remapper.readClassPath(new Path[]{minecraftDownloader.LIBRARIES.getResolvedPath()});
                remapper.apply((BiConsumer)outputConsumer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                remapper.finish();
            }
        });
        this.YARN_FILE_JAR = new Dependency("minecraft/" + minecraftDownloader.version + "/yarn-" + yarnVersion + "-v2.jar", DependencyUtilities.download(("https://maven.fabricmc.net/net/fabricmc/yarn/" + yarnVersion + "/yarn-" + yarnVersion + "-v2.jar").replace("+", "%2B")));
        this.YARN = new Dependency("minecraft/" + minecraftDownloader.version + "/yarn-" + yarnVersion + "-v2.tiny", dependency -> {
            JarFile jarFile = new JarFile(this.YARN_FILE_JAR.getResolvedFile());
            ZipEntry mappings = jarFile.getEntry("mappings/mappings.tiny");
            InputStream inputStream = jarFile.getInputStream(mappings);
            byte[] bytes = inputStream.readAllBytes();
            inputStream.close();
            Files.write(dependency.getPath(), bytes, new OpenOption[0]);
        });
        this.YARN_JAR = new Dependency("minecraft/" + minecraftDownloader.version + "/" + minecraftDownloader.version + "-yarn-" + yarnVersion + "-v2.jar", dependency -> {
            IMappingProvider mappingProvider = TinyUtils.createTinyMappingProvider((Path)this.YARN.getResolvedPath(), (String)"intermediary", (String)"named");
            TinyRemapper remapper = TinyRemapper.newRemapper().withMappings(mappingProvider).fixPackageAccess(true).rebuildSourceFilenames(true).threads(5).build();
            Path clientJarLoc = this.INTERMEDIARY_JAR.getResolvedPath();
            try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(dependency.getPath()).build();){
                outputConsumer.addNonClassFiles(clientJarLoc, NonClassCopyMode.FIX_META_INF, remapper);
                remapper.readInputs(new Path[]{clientJarLoc});
                remapper.readClassPath(new Path[]{clientJarLoc});
                remapper.readClassPath(new Path[]{minecraftDownloader.LIBRARIES.getResolvedPath()});
                remapper.apply((BiConsumer)outputConsumer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                remapper.finish();
            }
        });
    }
}

