/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mcdl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jab125.decompiler.Decompiler2;
import com.jab125.dependency.Dependency;
import com.jab125.dependency.DependencyUtilities;
import com.jab125.dependency.JsonDependency;
import com.jab125.dependency.Lazy;
import com.jab125.mccustom.constants.Constants;
import com.jab125.remapper.Remapper2;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;

public class MinecraftDownloader2 {
    public static final String VERSION_MANIFEST_URL = "https://piston-meta.mojang.com/mc/game/version_manifest_v2.json";
    public static final String RESOURCES_URL = "https://resources.download.minecraft.net/";
    public final String version;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public final JsonDependency VERSION_MANIFEST_V2;
    public final Lazy<JsonObject> MANIFEST_META;
    public final JsonDependency VERSION_META;
    public final Lazy<Integer> ASSETS_VERSION;
    public final JsonDependency ASSETS_META;
    public final Lazy<String> MAIN_CLASS;
    public final Dependency MINECRAFT_CLIENT;
    public final Dependency LIBRARIES;
    public final Dependency ASSETS;

    public MinecraftDownloader2(String mcVersion) {
        this.version = mcVersion;
        this.VERSION_MANIFEST_V2 = new JsonDependency("minecraft/manifest.json", DependencyUtilities.download(VERSION_MANIFEST_URL));
        this.MANIFEST_META = new Lazy<JsonObject>(() -> this.VERSION_MANIFEST_V2.asJsonArray("versions").asList().stream().filter(a -> {
            JsonObject object;
            return a instanceof JsonObject && (object = (JsonObject)a).getAsJsonPrimitive("id").getAsString().equals(this.version);
        }).findFirst().get().getAsJsonObject());
        this.VERSION_META = new JsonDependency("minecraft/" + this.version + "/" + this.version + ".json", dependency -> {
            String url = this.MANIFEST_META.get().getAsJsonPrimitive("url").getAsString();
            String str = new String(new URL(url).openStream().readAllBytes());
            Files.writeString(dependency.getPath(), (CharSequence)GSON.toJson((JsonElement)GSON.fromJson(str, JsonObject.class)), new OpenOption[0]);
        });
        this.ASSETS_VERSION = new Lazy<Integer>(() -> this.VERSION_META.asJsonPrimitive("assets").getAsInt());
        this.ASSETS_META = new JsonDependency("minecraft/assets/indexes/" + this.ASSETS_VERSION.get() + ".json", dependency -> {
            JsonObject assetIndex = this.VERSION_META.asJsonObject("assetIndex");
            String url = assetIndex.getAsJsonPrimitive("url").getAsString();
            String str = new String(new URL(url).openStream().readAllBytes());
            Files.writeString(dependency.getPath(), (CharSequence)GSON.toJson((JsonElement)GSON.fromJson(str, JsonObject.class)), new OpenOption[0]);
        });
        this.MAIN_CLASS = new Lazy<String>(() -> this.VERSION_META.asJsonPrimitive("mainClass").getAsString());
        this.MINECRAFT_CLIENT = new Dependency("minecraft/" + this.version + "/" + this.version + ".jar", dependency -> Files.write(dependency.getPath(), new URL(this.VERSION_META.asJsonObject("downloads").getAsJsonObject("client").getAsJsonPrimitive("url").getAsString()).openStream().readAllBytes(), new OpenOption[0]));
        this.LIBRARIES = new Dependency("minecraft/libraries", dependency -> {
            List<Library> librariesList = this.VERSION_META.asJsonArray("libraries").asList().stream().map(a -> (Library)GSON.fromJson(a, Library.class)).toList();
            List<Dependency> dependencies = librariesList.stream().map(library -> new Dependency("minecraft/libraries/" + library.downloads.artifact.sha1 + ".jar", dependency1 -> Files.write(dependency1.getPath(), new URL(library.downloads.artifact.url).openStream().readAllBytes(), new OpenOption[0]))).toList();
            for (Dependency dependency1 : dependencies) {
                dependency1.lazyResolve();
            }
        }){

            @Override
            public boolean exists() {
                return false;
            }
        };
        this.ASSETS = new Dependency("minecraft/assets", dependency -> {
            JsonObject objects = this.ASSETS_META.asJsonObject("objects");
            Set set = objects.entrySet();
            List<Dependency> dependencies = set.stream().map(object -> {
                String hash = ((JsonElement)object.getValue()).getAsJsonObject().getAsJsonPrimitive("hash").getAsString();
                String suffix = hash.substring(0, 2) + "/" + hash;
                String downloadUrl = RESOURCES_URL + suffix;
                return new Dependency("minecraft/assets/objects/" + suffix, dependency1 -> Files.write(dependency1.getPath(), new URL(downloadUrl).openStream().readAllBytes(), new OpenOption[0]));
            }).toList();
            for (Dependency dependency1 : dependencies) {
                dependency1.lazyResolve();
            }
        }){

            @Override
            public boolean exists() {
                return false;
            }
        };
    }

    public static void main(String[] args) {
        Constants.ROOT = Path.of("", new String[0]);
        MinecraftDownloader2 mcDownloader = new MinecraftDownloader2("1.20.1");
        mcDownloader.MINECRAFT_CLIENT.lazyResolve();
        mcDownloader.LIBRARIES.lazyResolve();
        mcDownloader.ASSETS.lazyResolve();
        System.out.println(mcDownloader.MAIN_CLASS.get());
        Remapper2 remapper = new Remapper2(mcDownloader, "1.20.1+build.9");
        remapper.INTERMEDIARY_JAR.lazyResolve();
        remapper.YARN_JAR.lazyResolve();
        Decompiler2 decompiler2 = new Decompiler2(mcDownloader, remapper);
        decompiler2.DECOMPILED_YARN.lazyResolve();
        decompiler2.MC_SRC_PATCHES_DIR.lazyResolve();
    }

    private record Library(Downloads downloads, String name) {
    }

    private record Downloads(Artifact artifact) {
    }

    private record Artifact(String path, String sha1, int size, String url) {
    }
}

