/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.patch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

class BinPatch {
    BinPatch() {
    }

    static byte[] createPatch(byte[] in, byte[] out) throws IOException {
        int originalSize = in.length;
        int modifiedSize = out.length;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        buf.write(ByteBuffer.allocate(4).putInt(originalSize).array());
        buf.write(ByteBuffer.allocate(4).putInt(modifiedSize).array());
        byte[] newBytes = new byte[modifiedSize];
        for (int i = 0; i < modifiedSize; ++i) {
            byte finished;
            byte original = in[i % originalSize];
            byte modified = out[i];
            newBytes[i] = finished = (byte)(modified - original);
        }
        buf.write(newBytes);
        return buf.toByteArray();
    }

    static byte[] applyPatch(byte[] in, byte[] patch) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(patch);
        int originalSize = ByteBuffer.allocate(4).put(byteArrayInputStream.readNBytes(4)).rewind().getInt();
        int modifiedSize = ByteBuffer.allocate(4).put(byteArrayInputStream.readNBytes(4)).rewind().getInt();
        byte[] patchFileBytes = byteArrayInputStream.readNBytes(modifiedSize);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < patchFileBytes.length; ++i) {
            out.write((byte)(in[i % originalSize] + patchFileBytes[i]));
        }
        return out.toByteArray();
    }
}

