/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mccustom.gradleplugin;

import com.jab125.decompiler.Decompiler;
import com.jab125.diff.api.DiffApi;
import com.jab125.mccustom.constants.Constants;
import com.jab125.mccustom.gradleplugin.McCustomExtensionAPI;
import com.jab125.mccustom.gradleplugin.McCustomExtensionImpl;
import com.jab125.mcdl.MinecraftDownloader;
import com.jab125.patch.api.PatchApi;
import com.jab125.recompiler.Recompiler;
import com.jab125.remapper.Remapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.PluginAware;

public class McCustomPlugin
implements Plugin<PluginAware> {
    public void apply(PluginAware pluginAware) {
        if (!(pluginAware instanceof Project)) {
            return;
        }
        Project project = (Project)pluginAware;
        McCustomExtensionAPI extension = (McCustomExtensionAPI)project.getExtensions().create(McCustomExtensionAPI.class, "mcCustom", McCustomExtensionImpl.class, new Object[]{project});
        MinecraftDownloader.VERSION = (String)extension.minecraft().get();
        Constants.toBePatched = (List)extension.patchedClasses().get();
        Decompiler.YARN = (String)extension.yarn().get();
        Constants.ROOT = project.getRootDir().toPath();
        project.task("decompileMinecraft", task -> {
            task.setDescription("Decompiles Minecraft");
            task.doFirst(c -> {
                try {
                    Constants.toBePatched = (List)extension.patchedClasses().get();
                    Decompiler.main(new String[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        });
        project.task("setupMinecraftSubproject", task -> {
            task.setDescription("Sets up the minecraft subproject, will OVERWRITE existing build.gradle!");
            task.doFirst(a -> {
                Path path = project.getRootDir().toPath().resolve("minecraft/build.gradle");
                path.toFile().getParentFile().mkdirs();
                try {
                    Files.writeString(path, (CharSequence)Constants.BUILD_GRADLE, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        });
        project.task("downloadMinecraft", task -> {
            task.setDescription("Downloads minecraft.");
            task.doFirst(c -> {
                try {
                    MinecraftDownloader.main(new String[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        });
        project.task("setupTools", task -> {
            task.setDescription("Initial setup for McCustom, ONLY RUN ON PROJECT CREATION!!!");
            task.finalizedBy(new Object[]{"downloadMinecraft", "decompileMinecraft", "setupMinecraftSubproject"});
        });
        project.task("compileMinecraft", task -> {
            task.dependsOn(new Object[]{":minecraft:shadowJar"});
            task.doLast(a -> {
                try {
                    Recompiler.recompile(project);
                    Remapper.remapJarFromYarnToIntermediary(MinecraftDownloader.VERSION, (String)extension.yarn().get());
                    Remapper.remapJarFromIntermediaryToOfficial(MinecraftDownloader.VERSION);
                    Path q = project.getBuildDir().toPath().resolve("libs/minecraft-patched-" + MinecraftDownloader.VERSION + ".jar");
                    q.toFile().getParentFile().mkdirs();
                    Files.copy(Constants.ROOT.resolve("minecraft/.install/client-patched-official.jar"), q, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException | InterruptedException e) {
                    throw new RuntimeException(e);
                }
            });
        });
        project.task("generatePatches", task -> task.doFirst(a -> DiffApi.newInstance().diffDirectories(Constants.ROOT.resolve("minecraft/mcpatty/original"), Constants.ROOT.resolve("minecraft/src/patches"), Constants.ROOT.resolve("patches"))));
        project.task("applyPatches", task -> task.doFirst(a -> PatchApi.newInstance().patchDirectory(Constants.ROOT.resolve("minecraft/mcpatty/original"), Constants.ROOT.resolve("patches"), Constants.ROOT.resolve("minecraft/src/patches"))));
        project.task("setupDevWorkspace", task -> {
            task.setDescription("Downloads and decompiles minecraft. Also applies all patches.");
            task.finalizedBy(new Object[]{"downloadMinecraft", "decompileMinecraft", "applyPatches"});
        });
    }
}

