/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.decompiler;

import com.jab125.dependency.Dependency;
import com.jab125.mccustom.constants.Constants;
import com.jab125.mcdl.MinecraftDownloader2;
import com.jab125.remapper.Remapper2;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jetbrains.java.decompiler.main.decompiler.ConsoleDecompiler;
import org.jetbrains.java.decompiler.main.decompiler.PrintStreamLogger;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;

public class Decompiler2 {
    private final MinecraftDownloader2 minecraftDownloader;
    private final Remapper2 remapper;
    private final Path mcSrcPatchesDir = Constants.ROOT.resolve("patchSrc");
    private final Path mcSrcUnmodifiedDir = Constants.ROOT.resolve("unmodifiedSrc");
    public final Dependency MC_SRC_ORIGINAL_DIR;
    public final Dependency MC_SRC_PATCHES_DIR;
    public final Dependency DECOMPILED_YARN;
    public final Dependency YARN_REMOVED_JAR;

    public Decompiler2(MinecraftDownloader2 minecraftDownloader, Remapper2 remapper) {
        this.minecraftDownloader = minecraftDownloader;
        this.remapper = remapper;
        Path log = Path.of("current.log", new String[0]);
        try {
            log.toFile().createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.DECOMPILED_YARN = new Dependency("minecraft/" + minecraftDownloader.version + "/decompiled", dependency -> {
            try {
                ConsoleDecompiler consoleDecompiler = new ConsoleDecompiler(dependency.getPath().toFile(), Map.of("ind", "\t"), (IFernflowerLogger)new PrintStreamLogger(new PrintStream(log.toFile())), ConsoleDecompiler.SaveType.FOLDER){};
                for (File file : Objects.requireNonNull(minecraftDownloader.LIBRARIES.getResolvedFile().listFiles(File::isFile))) {
                    consoleDecompiler.addLibrary(file);
                }
                consoleDecompiler.addSource(remapper.YARN_JAR.getResolvedFile());
                consoleDecompiler.decompileContext();
                consoleDecompiler.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.YARN_REMOVED_JAR = new Dependency("minecraft/" + minecraftDownloader.version + "/" + minecraftDownloader.version + "-yarn-dev.jar", dependency -> {
            this.DECOMPILED_YARN.lazyResolve();
            ZipFile zipFile = new ZipFile(remapper.YARN_JAR.getResolvedFile());
            Iterator<? extends ZipEntry> zipIt = zipFile.entries().asIterator();
            Path zipolk = Files.createTempFile(null, ".zip", new FileAttribute[0]);
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipolk.toFile()));
            while (zipIt.hasNext()) {
                ZipEntry entry = zipIt.next();
                ArrayList<String> toBePatched = new ArrayList<String>();
                Decompiler2.addToList(toBePatched);
                if (entry.getName().endsWith(".class") && toBePatched.contains(entry.getName().substring(0, entry.getName().length() - 6))) continue;
                System.out.println("keeping file");
                ZipEntry a = new ZipEntry(entry.getName());
                out.putNextEntry(a);
                out.write(zipFile.getInputStream(entry).readAllBytes());
                out.closeEntry();
            }
            zipFile.close();
            out.close();
            Files.copy(zipolk, dependency.getPath(), StandardCopyOption.REPLACE_EXISTING);
        });
        this.MC_SRC_ORIGINAL_DIR = new Dependency(this.mcSrcUnmodifiedDir, dependency -> {
            this.DECOMPILED_YARN.lazyResolve();
            dependency.getFile().mkdirs();
            ArrayList<String> toBePatched = new ArrayList<String>();
            Decompiler2.addToList(toBePatched);
            for (String s : toBePatched) {
                Dependency innerDep = new Dependency(dependency.getPath().resolve(s + ".java"), dependency1 -> {
                    System.out.println("copied to " + dependency1.getPath());
                    Files.copy(this.DECOMPILED_YARN.getPath().resolve(s + ".java"), dependency1.getPath(), StandardCopyOption.REPLACE_EXISTING);
                });
                innerDep.lazyResolve();
            }
        }){

            @Override
            public boolean exists() {
                return false;
            }

            @Override
            protected void mkdirs() {
            }
        };
        this.MC_SRC_PATCHES_DIR = new Dependency(this.mcSrcPatchesDir, dependency -> {
            this.MC_SRC_ORIGINAL_DIR.lazyResolve();
            dependency.getFile().mkdirs();
            ArrayList<String> toBePatched = new ArrayList<String>();
            Decompiler2.addToList(toBePatched);
            for (String s : toBePatched) {
                Dependency innerDep = new Dependency(dependency.getPath().resolve(s + ".java"), dependency1 -> Files.copy(this.MC_SRC_ORIGINAL_DIR.getPath().resolve(s + ".java"), dependency1.getPath(), StandardCopyOption.REPLACE_EXISTING));
                innerDep.lazyResolve();
            }
        }){

            @Override
            public boolean exists() {
                return false;
            }

            @Override
            protected void mkdirs() {
            }
        };
    }

    private static void addToList(ArrayList<String> toBePatched) {
        toBePatched.addAll(Constants.toBePatched);
    }
}

