/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.dependency;

import com.jab125.dependency.Dependency;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;

public class DependencyUtilities {
    public static Dependency.Resolver download(String url) {
        return dependency -> Files.write(dependency.getPath(), new URL(url).openStream().readAllBytes(), new OpenOption[0]);
    }

    public static Dependency.Resolver dependsOn(Dependency dependency) {
        return dependency2 -> dependency.lazyResolve();
    }

    public static ComplexResolverBuilder resolverBuilder() {
        return new ComplexResolverBuilder();
    }

    public static class ComplexResolverBuilder {
        private final List<Dependency.Resolver> resolvers = new ArrayList<Dependency.Resolver>();

        private ComplexResolverBuilder() {
        }

        public ComplexResolverBuilder addFirst(Dependency.Resolver resolver) {
            this.resolvers.add(0, resolver);
            return this;
        }

        public ComplexResolverBuilder addLast(Dependency.Resolver resolver) {
            this.resolvers.add(resolver);
            return this;
        }

        public ComplexResolver build() {
            return new ComplexResolver(List.copyOf(this.resolvers));
        }
    }

    private static class ComplexResolver
    implements Dependency.Resolver {
        private final List<Dependency.Resolver> resolvers;

        private ComplexResolver(List<Dependency.Resolver> resolvers) {
            this.resolvers = resolvers;
        }

        @Override
        public void resolve(Dependency dependency) throws Throwable {
            for (Dependency.Resolver resolver : this.resolvers) {
                resolver.resolve(dependency);
            }
        }
    }
}

