/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mccustom.gradleplugin;

import codechicken.diffpatch.cli.DiffOperation;
import codechicken.diffpatch.cli.PatchOperation;
import com.jab125.decompiler.Decompiler2;
import com.jab125.dependency.Lazy;
import com.jab125.mccustom.DirUtils;
import com.jab125.mccustom.RemoveImportInnerclassProcessor;
import com.jab125.mccustom.constants.Constants;
import com.jab125.mccustom.gradleplugin.McCustomExtensionAPI;
import com.jab125.mccustom.gradleplugin.McCustomExtensionImpl;
import com.jab125.mcdl.MinecraftDownloader2;
import com.jab125.remapper.Remapper2;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.lorenztiny.TinyMappingFormat;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.mercury.Mercury;
import org.cadixdev.mercury.SourceRewriter;
import org.cadixdev.mercury.remapper.MercuryRemapper;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.PluginAware;

public class McCustomPlugin
implements Plugin<PluginAware> {
    public void apply(PluginAware pluginAware) {
        if (!(pluginAware instanceof Project)) {
            return;
        }
        Project project = (Project)pluginAware;
        McCustomExtensionAPI extension = (McCustomExtensionAPI)project.getExtensions().create(McCustomExtensionAPI.class, "mcCustom", McCustomExtensionImpl.class, new Object[]{project});
        Constants.ROOT = project.getRootDir().toPath();
        Lazy<MinecraftDownloader2> minecraftDownloader = new Lazy<MinecraftDownloader2>(() -> new MinecraftDownloader2((String)extension.minecraft().get()));
        Lazy<Remapper2> remapper = new Lazy<Remapper2>(() -> new Remapper2((MinecraftDownloader2)minecraftDownloader.get(), (String)extension.yarn().get()));
        Lazy<Decompiler2> decompiler = new Lazy<Decompiler2>(() -> {
            Constants.toBePatched = (List)extension.patchedClasses().get();
            return new Decompiler2((MinecraftDownloader2)minecraftDownloader.get(), (Remapper2)remapper.get());
        });
        project.task("decompileMinecraft", task -> {
            task.setDescription("Decompiles Minecraft");
            task.doFirst(c -> ((Decompiler2)decompiler.get()).DECOMPILED_YARN.lazyResolve());
        });
        project.task("setupModifications", task -> {
            task.setDescription("Move classes that will be modified and creates a jar with the modified classes omitted.");
            task.doFirst(c -> {
                ((Decompiler2)decompiler.get()).YARN_REMOVED_JAR.lazyResolve();
                ((Decompiler2)decompiler.get()).MC_SRC_ORIGINAL_DIR.lazyResolve();
                ((Decompiler2)decompiler.get()).MC_SRC_PATCHES_DIR.lazyResolve();
            });
        });
        project.task("downloadMinecraft", task -> {
            task.setDescription("Downloads minecraft.");
            task.doFirst(c -> ((MinecraftDownloader2)minecraftDownloader.get()).MINECRAFT_CLIENT.lazyResolve());
        });
        project.task("downloadLibraries", task -> {
            task.setDescription("Downloads libraries.");
            task.doFirst(c -> ((MinecraftDownloader2)minecraftDownloader.get()).LIBRARIES.lazyResolve());
        });
        project.task("downloadAssets", task -> {
            task.setDescription("Downloads assets.");
            task.doFirst(c -> ((MinecraftDownloader2)minecraftDownloader.get()).ASSETS.lazyResolve());
        });
        project.task("setupTools", task -> {
            task.setDescription("Initial setup for McCustom, ONLY RUN ON PROJECT CREATION!!!");
            task.finalizedBy(new Object[]{"downloadMinecraft", "downloadLibraries", "downloadAssets", "decompileMinecraft"});
        });
        project.task("generatePatches", task -> {
            task.dependsOn(new Object[]{"build"});
            task.doFirst(a -> {
                try {
                    Mercury mercury = new Mercury();
                    mercury.getProcessors().add(new RemoveImportInnerclassProcessor());
                    for (File file : ((MinecraftDownloader2)minecraftDownloader.get()).LIBRARIES.getResolvedFile().listFiles(File::isFile)) {
                        mercury.getClassPath().add(file.toPath());
                    }
                    for (File file : project.getConfigurations().getByName("library").resolve()) {
                        mercury.getClassPath().add(file.toPath());
                    }
                    mercury.getClassPath().add(((Decompiler2)decompiler.get()).YARN_REMOVED_JAR.getResolvedPath());
                    mercury.getClassPath().add(Constants.ROOT.resolve("build/classes/java/main"));
                    mercury.getProcessors().add(MercuryRemapper.create((MappingSet)TinyMappingFormat.TINY_2.read(((Remapper2)remapper.get()).YARN.getPath(), "named", "intermediary")));
                    Path resolve = Constants.ROOT.resolve("cache/tempInter");
                    mercury.rewrite(((Decompiler2)decompiler.get()).MC_SRC_PATCHES_DIR.getResolvedPath(), resolve);
                    Path resolve1 = Constants.ROOT.resolve("cache/tempInter2");
                    mercury.rewrite(((Decompiler2)decompiler.get()).MC_SRC_ORIGINAL_DIR.getResolvedPath(), resolve1);
                    DiffOperation.builder().aPath(resolve1).bPath(resolve).outputPath(Constants.ROOT.resolve("patches")).lineEnding("\n").build().operate();
                    DirUtils.deleteDirectory(resolve1);
                    DirUtils.deleteDirectory(resolve);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        });
        project.task("applyPatches", task -> task.doFirst(a -> {
            Path yrn = ((Decompiler2)decompiler.get()).YARN_REMOVED_JAR.getResolvedPath();
            Mercury mercury = new Mercury();
            mercury.getProcessors().add(new RemoveImportInnerclassProcessor());
            for (File file : ((MinecraftDownloader2)minecraftDownloader.get()).LIBRARIES.getResolvedFile().listFiles(File::isFile)) {
                mercury.getClassPath().add(file.toPath());
            }
            for (File file : project.getConfigurations().getByName("library").resolve()) {
                mercury.getClassPath().add(file.toPath());
            }
            mercury.getClassPath().add(yrn);
            SourceRewriter g = null;
            try {
                g = MercuryRemapper.create((MappingSet)TinyMappingFormat.TINY_2.read(((Remapper2)remapper.get()).YARN.getPath(), "named", "intermediary"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            mercury.getProcessors().add(g);
            Path resolve = Constants.ROOT.resolve("cache/tempin");
            Path resolve2 = Constants.ROOT.resolve("cache/tempin2");
            Path resolve3 = Constants.ROOT.resolve("patches");
            Path resolve4 = Constants.ROOT.resolve("patchSrc");
            try {
                try {
                    mercury.rewrite(((Decompiler2)decompiler.get()).MC_SRC_ORIGINAL_DIR.getResolvedPath(), resolve);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                try {
                    PatchOperation.builder().basePath(resolve).outputPath(resolve2).patchesPath(resolve3).build().operate();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                mercury.getProcessors().remove(g);
                mercury.getClassPath().remove(yrn);
                mercury.getClassPath().add(((Remapper2)remapper.get()).INTERMEDIARY_JAR.getResolvedPath());
                mercury.getClassPath().add(((Remapper2)remapper.get()).YARN_JAR.getResolvedPath());
                try {
                    g = MercuryRemapper.create((MappingSet)TinyMappingFormat.TINY_2.read(((Remapper2)remapper.get()).YARN.getPath(), "intermediary", "named"));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                mercury.setSourceCompatibility("17");
                mercury.setGracefulClasspathChecks(true);
                mercury.getProcessors().add(g);
                try {
                    mercury.rewrite(resolve2, resolve4);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable t) {
                System.err.println("FAILED");
            }
            finally {
                DirUtils.deleteDirectory(resolve);
                DirUtils.deleteDirectory(resolve2);
            }
        }));
    }
}

