/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mcdl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jab125.mccustom.constants.Constants;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MinecraftDownloader {
    public static final String VERSION_MANIFEST_URL = "https://piston-meta.mojang.com/mc/game/version_manifest_v2.json";
    public static String VERSION = "1.20.1";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static JsonObject VERSION_META;
    private static JsonObject MANIFEST_META;
    private static JsonObject ASSETS_META;
    private static int ASSETS_VERSION;
    public static Path TEMP_DIR;
    private static final Classpath CLASSPATH;
    public static final String RESOURCES_URL = "https://resources.download.minecraft.net/";
    public static String MAIN_CLASS;

    public static void downloadLibrariesMeta() throws IOException {
        System.out.println("Downloading meta");
        long time = System.currentTimeMillis();
        TEMP_DIR = Constants.ROOT.resolve("minecraft/.install");
        TEMP_DIR.toFile().mkdirs();
        Files.write(TEMP_DIR.resolve("version_manifest.json"), new URL(VERSION_MANIFEST_URL).openStream().readAllBytes(), new OpenOption[0]);
        JsonObject jsonObject = (JsonObject)GSON.fromJson(new String(Files.readAllBytes(TEMP_DIR.resolve("version_manifest.json"))), JsonObject.class);
        MANIFEST_META = jsonObject.getAsJsonArray("versions").asList().stream().filter(a -> {
            JsonObject object;
            return a instanceof JsonObject && (object = (JsonObject)a).getAsJsonPrimitive("id").getAsString().equals(VERSION);
        }).findFirst().get().getAsJsonObject();
        String url = MANIFEST_META.getAsJsonPrimitive("url").getAsString();
        String str = new String(new URL(url).openStream().readAllBytes());
        VERSION_META = (JsonObject)GSON.fromJson(str, JsonObject.class);
        JsonObject ainx = VERSION_META.getAsJsonObject("assetIndex");
        url = ainx.getAsJsonPrimitive("url").getAsString();
        str = new String(new URL(url).openStream().readAllBytes());
        ASSETS_META = (JsonObject)GSON.fromJson(str, JsonObject.class);
        ASSETS_VERSION = VERSION_META.getAsJsonPrimitive("assets").getAsInt();
        TEMP_DIR.resolve("assets/indexes").toFile().mkdirs();
        Files.writeString(TEMP_DIR.resolve("assets/indexes/" + ASSETS_VERSION + ".json"), (CharSequence)GSON.toJson((JsonElement)ASSETS_META), new OpenOption[0]);
        MAIN_CLASS = VERSION_META.getAsJsonPrimitive("mainClass").getAsString();
        System.out.println("Downloaded meta in " + (System.currentTimeMillis() - time) + "ms");
    }

    public static void main(String[] args) throws IOException {
        MinecraftDownloader.downloadLibrariesMeta();
        MinecraftDownloader.downloadClient();
        MinecraftDownloader.downloadLibraries();
        MinecraftDownloader.createMacOSExecutable();
    }

    private static void createMacOSExecutable() throws IOException {
        String classpath = CLASSPATH.toUnixString();
        String javaURL = "java";
        StringBuilder shFile = new StringBuilder();
        shFile.append("chmod +x ").append("\"" + javaURL + "\"\n");
        shFile.append("\"" + javaURL + "\"");
        shFile.append(" -XstartOnFirstThread -Xmx3G ");
        shFile.append("-cp \"");
        shFile.append(classpath).append("\" ");
        shFile.append(MAIN_CLASS).append(" --accessToken \"\"").append(" --version ").append(VERSION);
        Files.writeString(TEMP_DIR.resolve("run.sh"), (CharSequence)shFile.toString(), new OpenOption[0]);
    }

    private static void downloadAssets() throws IOException {
        System.out.println("Downloading assets");
        long initialStartTime = System.currentTimeMillis();
        JsonObject objects = ASSETS_META.getAsJsonObject("objects");
        Set set = objects.entrySet();
        int i = 1;
        int amount = set.size();
        for (Map.Entry object : set) {
            long downloadTime = System.currentTimeMillis();
            String hash = ((JsonElement)object.getValue()).getAsJsonObject().getAsJsonPrimitive("hash").getAsString();
            String suffix = hash.substring(0, 2) + "/" + hash;
            String downloadUrl = RESOURCES_URL + suffix;
            Path downloadPath = TEMP_DIR.resolve("assets/objects/" + suffix);
            downloadPath.toFile().getParentFile().mkdirs();
            Files.write(downloadPath, new URL(downloadUrl).openStream().readAllBytes(), new OpenOption[0]);
            System.out.println(MessageFormat.format("Downloaded {2} in {3}ms {0}/{1}", i, amount, object.getKey(), System.currentTimeMillis() - downloadTime));
            ++i;
        }
        System.out.println("Downloaded assets in " + (System.currentTimeMillis() - initialStartTime) + "ms");
    }

    private static void downloadLibraries() throws IOException {
        TEMP_DIR.resolve("libraries").toFile().mkdirs();
        System.out.println("Downloading libraries");
        long initialStartTime = System.currentTimeMillis();
        List<Library> librariesList = VERSION_META.getAsJsonArray("libraries").asList().stream().map(a -> (Library)GSON.fromJson(a, Library.class)).toList();
        int i = 1;
        int amount = librariesList.size();
        for (Library library : librariesList) {
            CLASSPATH.addLibrary(library);
            long downloadTime = System.currentTimeMillis();
            String downloadedFileName = library.downloads.artifact.sha1 + ".jar";
            String downloadUrl = library.downloads().artifact().url();
            Path downloadedFilePath = TEMP_DIR.resolve("libraries/" + downloadedFileName);
            Files.write(downloadedFilePath, new URL(downloadUrl).openStream().readAllBytes(), new OpenOption[0]);
            System.out.println(MessageFormat.format("Downloaded {2} in {3}ms {0}/{1}", i, amount, library.name(), System.currentTimeMillis() - downloadTime));
            ++i;
        }
        System.out.println("Downloaded libraries in " + (System.currentTimeMillis() - initialStartTime) + "ms");
    }

    private static void downloadClient() throws IOException {
        System.out.println("Downloading client");
        long time = System.currentTimeMillis();
        String clientJarUrl = VERSION_META.getAsJsonObject("downloads").getAsJsonObject("client").getAsJsonPrimitive("url").getAsString();
        Files.write(TEMP_DIR.resolve("client.jar"), new URL(clientJarUrl).openStream().readAllBytes(), new OpenOption[0]);
        CLASSPATH.addPath("client.jar");
        System.out.println("Downloaded client in " + (System.currentTimeMillis() - time) + "ms");
    }

    static {
        CLASSPATH = new Classpath();
    }

    private static class Classpath {
        private final ArrayList<ConditionalPath> cp = new ArrayList();

        private Classpath() {
        }

        public void addLibrary(Library library) {
            this.cp.add(new ConditionalPath("libraries/" + library.downloads.artifact.sha1 + ".jar", new ConditionalPath.Rules()));
        }

        public void addPath(String path) {
            this.cp.add(new ConditionalPath(path, new ConditionalPath.Rules()));
        }

        public String toUnixString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (ConditionalPath conditionalPath : this.cp) {
                stringBuilder.append(conditionalPath.path + ":");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            return stringBuilder.toString();
        }

        public String toWindowsString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (ConditionalPath conditionalPath : this.cp) {
                stringBuilder.append(conditionalPath.path + ";");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            return stringBuilder.toString();
        }

        private static class ConditionalPath {
            private final String path;
            private final Rules rules;

            public ConditionalPath(String string, Rules rules) {
                this.path = string;
                this.rules = rules;
            }

            private static class Rules {
                private Rules() {
                }
            }
        }
    }

    private record Library(Downloads downloads, String name) {
    }

    private record Downloads(Artifact artifact) {
    }

    private record Artifact(String path, String sha1, int size, String url) {
    }
}

