/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.dependency;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.jab125.dependency.Dependency;
import com.jab125.dependency.Lazy;

public class JsonDependency
extends Dependency {
    private static final Gson GSON = new Gson();
    private final Lazy<JsonElement> jsonElementLazy = new Lazy<JsonElement>(() -> (JsonElement)GSON.fromJson(this.getString(), JsonElement.class));
    private final Lazy<JsonObject> jsonObjectLazy = new Lazy<JsonObject>(() -> this.jsonElementLazy.get().getAsJsonObject());
    private final Lazy<JsonPrimitive> jsonPrimitiveLazy = new Lazy<JsonPrimitive>(() -> this.jsonElementLazy.get().getAsJsonPrimitive());
    private final Lazy<JsonArray> jsonArrayLazy = new Lazy<JsonArray>(() -> this.jsonElementLazy.get().getAsJsonArray());

    public JsonDependency(String path, Dependency.Resolver resolver) {
        super(path, resolver);
    }

    public JsonElement asJsonElement() {
        this.lazyResolve();
        return this.jsonElementLazy.get();
    }

    public JsonObject asJsonObject() {
        this.lazyResolve();
        return this.jsonObjectLazy.get();
    }

    public JsonObject asJsonObject(String key) {
        this.lazyResolve();
        return this.jsonObjectLazy.get().getAsJsonObject(key);
    }

    public JsonPrimitive asJsonPrimitive() {
        this.lazyResolve();
        return this.jsonPrimitiveLazy.get();
    }

    public JsonPrimitive asJsonPrimitive(String key) {
        this.lazyResolve();
        return this.jsonObjectLazy.get().getAsJsonPrimitive(key);
    }

    public JsonArray asJsonArray() {
        this.lazyResolve();
        return this.jsonArrayLazy.get();
    }

    public JsonArray asJsonArray(String key) {
        this.lazyResolve();
        return this.jsonObjectLazy.get().getAsJsonArray(key);
    }
}

