/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mccustom;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class DirUtils {
    public static void copyMultipleDirectoriesToSingleDestination(final Path destination, Path ... directories) {
        try {
            if (!Files.exists(destination, new LinkOption[0])) {
                Files.createDirectories(destination, new FileAttribute[0]);
            }
            for (final Path sourceDir : directories) {
                Files.walkFileTree(sourceDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path destFile = destination.resolve(sourceDir.relativize(file));
                        Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Path targetDir = destination.resolve(sourceDir.relativize(dir));
                        if (!Files.exists(targetDir, new LinkOption[0])) {
                            Files.createDirectories(targetDir, new FileAttribute[0]);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void deleteDirectory(Path directory) {
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<String> collect(Path directory) {
        ArrayList<String> pathsList = new ArrayList<String>();
        DirUtils.collectPaths(directory, directory, pathsList);
        return pathsList;
    }

    private static void collectPaths(Path root, Path directory, List<String> pathsList) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
            for (Path entry : stream) {
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    DirUtils.collectPaths(root, entry, pathsList);
                    continue;
                }
                String relativePath = root.relativize(entry).toString();
                pathsList.add(relativePath);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

