/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.patch;

import com.jab125.patch.BinPatch;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class BinaryPatch {
    public static void applyPatch(Path input, Path output, Path patches) {
        byte[] inputBytes = BinaryPatch.readAllBytes(input);
        byte[] patchesBytes = BinaryPatch.readAllBytes(patches);
        BinaryPatch.write(output, BinaryPatch.patch2(inputBytes, patchesBytes), new OpenOption[0]);
    }

    public static void createPatch(Path original, Path modified, Path patches) {
        byte[] originalBytes = BinaryPatch.readAllBytes(original);
        byte[] modifiedBytes = BinaryPatch.readAllBytes(modified);
        BinaryPatch.write(patches, BinaryPatch.patch(originalBytes, modifiedBytes), new OpenOption[0]);
    }

    private static byte[] patch(byte[] originalBytes, byte[] modifiedBytes) {
        try {
            return BinPatch.createPatch(originalBytes, modifiedBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] patch2(byte[] input, byte[] patch) {
        try {
            return BinPatch.applyPatch(input, patch);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Path createTempFile(String prefix, String suffix, FileAttribute<?> ... attrs) {
        try {
            return Files.createTempFile(prefix, suffix, attrs);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] readAllBytes(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Path write(Path path, byte[] bytes, OpenOption ... options) {
        try {
            return Files.write(path, bytes, options);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

