package springboard.plugin;

import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.impl.game.minecraft.patch.EntrypointPatchFML125;
import net.fabricmc.loader.impl.launch.knot.Knot;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.At;
import springboard.Springboard;
import springboard.api.SpringboardCandidateEntrypoint;
import springboard.tweak.classloader.CustomCandiateTransformer;
import springboard.tweak.classloader.FabricLoaderImplTransformer;
import springboard.tweak.classloader.ModCandidateTransformer;
import springboard.tweak.classloader.TweakingClassLoader;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarFile;

public class SpringboardPlugin implements IMixinConfigPlugin {
    @Override
    public void onLoad(String mixinPackage) {

        if ("true".equals(System.getProperty("springboard"))) return;
        final ArrayList<Path> suggestedMods = new ArrayList<>();
        AtomicBoolean cancelled = new AtomicBoolean(false);
        List<SpringboardCandidateEntrypoint> entrypoints = FabricLoader.getInstance().getEntrypoints("springboard:mod-suggestor", SpringboardCandidateEntrypoint.class);
        for (SpringboardCandidateEntrypoint entrypoint : entrypoints) {
            entrypoint.suggestMods(new CandidateAdder() {
                @Override
                public void suggest(Path path) {
                    suggestedMods.add(path);
                }

                @Override
                public void cancelCompletely() {
                    cancelled.set(true);
                }
            });
            if (cancelled.get()) return;
        }
        String[] launchArguments = FabricLoader.getInstance().getLaunchArguments(false);
//        try {
//         //   Files.copy(FabricLoader.getInstance().getGameDir().resolve(".springboard/modmenu-7.2.1.jar"), FabricLoader.getInstance().getGameDir().resolve("mods/modmenu-7.2.1.jar"));
//        } catch (IOException e) {
//            throw new RuntimeException(e);
//        }
        TweakingClassLoader tweakingClassLoader = new TweakingClassLoader(getURLs());
        tweakingClassLoader.addTransformer(new FabricLoaderImplTransformer());
        tweakingClassLoader.addTransformer(new CustomCandiateTransformer());
        tweakingClassLoader.addTransformer(new ModCandidateTransformer());
        Thread.currentThread().setContextClassLoader(tweakingClassLoader);
        Thread.currentThread().setUncaughtExceptionHandler((a, b) -> {});

     //   Thread thread = new Thread(() -> {
            Method main = null;
            try {
                //System.setProperty("fabric.dli.config", "/Users/josephyap/Documents/GitHub/bleh/springboard/.gradle/loom-cache/launch.cfg"); System.setProperty("fabric.dli.env", "client"); System.setProperty("fabric.dli.main", "net.fabricmc.loader.impl.launch.knot.KnotClient");
                main = Class.forName("springboard.Springboard", true, tweakingClassLoader).getMethod("main", String[].class, List.class);
            } catch (NoSuchMethodException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            try {
                main.invoke(null, (Object) launchArguments, suggestedMods);
            } catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            // net.fabricmc.devlaunchinjector.Main.main(new String[0]);
    //    });
    //    thread.start();
        throwsUnchecked(new Throwable());
//        List<JarFile> jars = new ArrayList<>();
//        searchForJars(jars);
//        for (JarFile jar : jars) {
//
//        }
//        try {
//            Springboard.createClassLoader(List.of("springboard-1.0.0-dev.jar"));
//        } catch (Exception e) {
//            throw new RuntimeException(e);
//        }
    }

    /**
     * Remember, Generics are erased in Java. So this basically throws an Exception. The real
     * Type of T is lost during the compilation
     */
    public static <T extends Throwable> void throwsUnchecked(Throwable toThrow) throws T{
        // Since the type is erased, this cast actually does nothing!!!
        // we can throw any exception
        throw (T) toThrow;
    }

    private void searchForJars(List<JarFile> jarFiles) {

    }

    @Override
    public String getRefMapperConfig() {
        return null;
    }

    @Override
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return false;
    }

    @Override
    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {

    }

    @Override
    public List<String> getMixins() {
        return null;
    }

    @Override
    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {

    }

    @Override
    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {

    }

    private static URL[] getURLs() {
        boolean dev = FabricLoader.getInstance().isDevelopmentEnvironment();
        String cp = System.getProperty("java.class.path");
        String[] elements = cp.split(File.pathSeparator);
        if (elements.length == 0) {
            elements = new String[]{""};
        }
        URL[] urls = new URL[dev ? elements.length : elements.length + 1];
        for (int i = 0; i < elements.length; i++) {
            try {
                URL url = new File(elements[i]).toURI().toURL();
                urls[i] = url;
            } catch (MalformedURLException ignore) {
                // malformed file string or class path element does not exist
            }
        }
        if (!dev) urls[elements.length] = SpringboardPlugin.class.getProtectionDomain().getCodeSource().getLocation();
        return urls;
    }
}
