/*
 * Decompiled with CFR 0.152.
 */
package springboard.api;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;

public interface SpringboardMeta {
    public String id();

    public String name();

    public String description();

    public String[] authors();

    public Map<String, String[]> entrypoints();

    public boolean unloadable();

    public boolean runtimeLoadable();

    public static SpringboardMeta read(String str) {
        final JsonObject jsonObject = (JsonObject)new Gson().fromJson(str, JsonObject.class);
        return new SpringboardMeta(){

            @Override
            public String id() {
                return jsonObject.getAsJsonPrimitive("id").getAsString();
            }

            @Override
            public String name() {
                return jsonObject.getAsJsonPrimitive("name").getAsString();
            }

            @Override
            public String description() {
                return jsonObject.getAsJsonPrimitive("description").getAsString();
            }

            @Override
            public String[] authors() {
                return (String[])jsonObject.getAsJsonArray("authors").asList().stream().map(JsonElement::getAsString).toArray(String[]::new);
            }

            @Override
            public Map<String, String[]> entrypoints() {
                HashMap<String, String[]> m = new HashMap<String, String[]>();
                JsonObject eps = jsonObject.getAsJsonObject("entrypoints");
                for (String s : eps.keySet()) {
                    m.put(s, (String[])eps.get(s).getAsJsonArray().asList().stream().map(JsonElement::getAsString).toArray(String[]::new));
                }
                return Map.copyOf(m);
            }

            @Override
            public boolean unloadable() {
                return jsonObject.getAsJsonPrimitive("unloadable").getAsBoolean();
            }

            @Override
            public boolean runtimeLoadable() {
                return jsonObject.getAsJsonPrimitive("runtimeLoadable").getAsBoolean();
            }
        };
    }
}

