/*
 * Decompiled with CFR 0.152.
 */
package springboard.plugin;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarFile;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import springboard.api.SpringboardCandidateEntrypoint;
import springboard.plugin.CandidateAdder;
import springboard.tweak.classloader.CustomCandiateTransformer;
import springboard.tweak.classloader.FabricLoaderImplTransformer;
import springboard.tweak.classloader.ModCandidateTransformer;
import springboard.tweak.classloader.TweakingClassLoader;

public class SpringboardPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
        if ("true".equals(System.getProperty("springboard"))) {
            return;
        }
        final ArrayList suggestedMods = new ArrayList();
        final AtomicBoolean cancelled = new AtomicBoolean(false);
        List entrypoints = FabricLoader.getInstance().getEntrypoints("springboard:mod-suggestor", SpringboardCandidateEntrypoint.class);
        for (SpringboardCandidateEntrypoint entrypoint : entrypoints) {
            entrypoint.suggestMods(new CandidateAdder(){

                @Override
                public void suggest(Path path) {
                    suggestedMods.add(path);
                }

                @Override
                public void cancelCompletely() {
                    cancelled.set(true);
                }
            });
            if (!cancelled.get()) continue;
            return;
        }
        String[] launchArguments = FabricLoader.getInstance().getLaunchArguments(false);
        TweakingClassLoader tweakingClassLoader = new TweakingClassLoader(SpringboardPlugin.getURLs());
        tweakingClassLoader.addTransformer(new FabricLoaderImplTransformer());
        tweakingClassLoader.addTransformer(new CustomCandiateTransformer());
        tweakingClassLoader.addTransformer(new ModCandidateTransformer());
        Thread.currentThread().setContextClassLoader(tweakingClassLoader);
        Thread.currentThread().setUncaughtExceptionHandler((a, b) -> {});
        Method main = null;
        try {
            main = Class.forName("springboard.Springboard", true, tweakingClassLoader).getMethod("main", String[].class, List.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        try {
            main.invoke(null, launchArguments, suggestedMods);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        SpringboardPlugin.throwsUnchecked(new Throwable());
    }

    public static <T extends Throwable> void throwsUnchecked(Throwable toThrow) throws T {
        throw toThrow;
    }

    private void searchForJars(List<JarFile> jarFiles) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return false;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static URL[] getURLs() {
        boolean dev = FabricLoader.getInstance().isDevelopmentEnvironment();
        String cp = System.getProperty("java.class.path");
        String[] elements = cp.split(File.pathSeparator);
        if (elements.length == 0) {
            elements = new String[]{""};
        }
        URL[] urls = new URL[dev ? elements.length : elements.length + 1];
        for (int i = 0; i < elements.length; ++i) {
            try {
                URL url;
                urls[i] = url = new File(elements[i]).toURI().toURL();
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (!dev) {
            urls[elements.length] = SpringboardPlugin.class.getProtectionDomain().getCodeSource().getLocation();
        }
        return urls;
    }
}

