/*
 * Decompiled with CFR 0.152.
 */
package springboard.init;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import springboard.api.SpringboardCandidateEntrypoint;
import springboard.plugin.CandidateAdder;
import springboard.plugin.SpringboardPlugin;
import springboard.tweak.classloader.ClassTransformer;
import springboard.tweak.classloader.CustomCandiateTransformer;
import springboard.tweak.classloader.FabricLoaderImplTransformer;
import springboard.tweak.classloader.ModCandidateTransformer;
import springboard.tweak.classloader.TweakingClassLoader;

public class Init {
    public static void extracted(String from) {
        if ("true".equals(System.getProperty("springboard"))) {
            return;
        }
        System.out.println("Loading Springboard via " + from);
        boolean client = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
        final ArrayList suggestedMods = new ArrayList();
        final ArrayList<URL> suggestedClasspathAddition = new ArrayList<URL>();
        final ArrayList suggestedEarlyEntrypoint = new ArrayList();
        final ArrayList<String> exclusions = new ArrayList<String>();
        final ArrayList transformers = new ArrayList();
        final AtomicBoolean cancelled = new AtomicBoolean(false);
        ArrayList<SpringboardCandidateEntrypoint> entrypoints = new ArrayList<SpringboardCandidateEntrypoint>(FabricLoader.getInstance().getEntrypoints("springboard:mod-suggestor", SpringboardCandidateEntrypoint.class));
        for (ModContainer allMod : FabricLoader.getInstance().getAllMods()) {
            if (!allMod.getMetadata().containsCustomValue("springboard:mod-suggestor")) continue;
            try {
                entrypoints.add((SpringboardCandidateEntrypoint)Class.forName(allMod.getMetadata().getCustomValue("springboard:mod-suggestor").getAsString()).newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        for (SpringboardCandidateEntrypoint entrypoint : entrypoints) {
            entrypoint.suggestMods(new CandidateAdder(){

                @Override
                public void suggest(Path path) {
                    suggestedMods.add(path);
                }

                @Override
                public void cancelCompletely() {
                    cancelled.set(true);
                }

                @Override
                public void suggestPreinitClasspathAddition(URL path) {
                    suggestedClasspathAddition.add(path);
                }

                @Override
                public void suggestEarlyEntrypoint(String clazz) {
                    suggestedEarlyEntrypoint.add(clazz);
                }

                @Override
                public void suggestExclusion(String prefix) {
                    exclusions.add(prefix);
                }

                @Override
                public void suggestTransformer(ClassTransformer transformer) {
                    transformers.add(transformer);
                }
            });
            if (!cancelled.get()) continue;
            return;
        }
        String[] launchArguments = FabricLoader.getInstance().getLaunchArguments(false);
        TweakingClassLoader tweakingClassLoader = new TweakingClassLoader(Init.getURLs(suggestedClasspathAddition), exclusions);
        tweakingClassLoader.addTransformer(new FabricLoaderImplTransformer());
        tweakingClassLoader.addTransformer(new CustomCandiateTransformer());
        tweakingClassLoader.addTransformer(new ModCandidateTransformer());
        for (ClassTransformer transformer : transformers) {
            tweakingClassLoader.addTransformer(transformer);
        }
        Thread.currentThread().setContextClassLoader(tweakingClassLoader);
        Thread.currentThread().setUncaughtExceptionHandler((a, b) -> {
            if (!"main thread closed.".equals(b.getMessage())) {
                b.printStackTrace();
            }
        });
        try {
            Method main = null;
            try {
                main = Class.forName("springboard.Springboard", true, tweakingClassLoader).getMethod("main", String[].class, List.class, List.class, Boolean.TYPE);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            try {
                main.invoke(null, launchArguments, suggestedMods, suggestedEarlyEntrypoint, client);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable e) {
            Init.throwsUnchecked(new Throwable(e));
        }
        Thread.currentThread().setUncaughtExceptionHandler((a, b) -> {});
        Init.throwsUnchecked(new Throwable("main thread closed."));
    }

    private static URL[] getURLs(ArrayList<URL> suggestedClasspathAddition) {
        boolean dev = FabricLoader.getInstance().isDevelopmentEnvironment();
        String cp = System.getProperty("java.class.path");
        String[] elements = cp.split(File.pathSeparator);
        if (elements.length == 0) {
            elements = new String[]{""};
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String element : elements) {
            try {
                URL url = new File(element).toURI().toURL();
                urls.add(url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        urls.addAll(suggestedClasspathAddition);
        if (!dev) {
            urls.add(SpringboardPlugin.class.getProtectionDomain().getCodeSource().getLocation());
        }
        return urls.toArray(new URL[0]);
    }

    public static <T extends Throwable> void throwsUnchecked(Throwable toThrow) throws T {
        throw toThrow;
    }

    public static <T extends Throwable, U> U throwsUncheckedReturn(Throwable toThrow) throws T {
        throw toThrow;
    }
}

