/*
 * Decompiled with CFR 0.152.
 */
package springboard.tweak.classloader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import springboard.tweak.classloader.ClassTransformer;

public class TweakingClassLoader
extends URLClassLoader {
    private final List<URL> classpath;
    private final Map<String, Class<?>> cachedClasses;
    private final List<String> exclusions;
    private final Map<String, byte[]> cachedResources;
    private final List<ClassTransformer> classTransformers = new ArrayList<ClassTransformer>();

    public TweakingClassLoader(URL[] classpath, List<String> exclusions2) {
        super(classpath, (ClassLoader)null);
        this.classpath = new ArrayList<URL>(Arrays.asList(classpath));
        this.cachedClasses = new HashMap();
        this.exclusions = new ArrayList<String>();
        this.exclusions.add("java.");
        this.exclusions.add("springboard.plugin.");
        this.exclusions.add("springboard.tweak.");
        this.exclusions.add("javax.");
        this.exclusions.add("sun.misc.");
        this.exclusions.add("sun.reflect.");
        this.exclusions.add("jdk.");
        this.exclusions.add("com.sun.");
        this.exclusions.addAll(exclusions2);
        this.cachedResources = new ConcurrentHashMap<String, byte[]>();
        this.loadTransformersFromServices();
    }

    private void loadTransformersFromServices() {
        for (ClassTransformer classTransformer : ServiceLoader.load(ClassTransformer.class)) {
            this.addTransformer(classTransformer);
        }
    }

    public void addTransformer(ClassTransformer transformer) {
        this.classTransformers.add(transformer);
    }

    private String toInternalName(String className) {
        return className.replaceAll("\\.", "/");
    }

    private String toApiName(String className) {
        return className.replaceAll("/", ".");
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.exclusions.stream().anyMatch(name::startsWith)) {
            return Class.forName(name, true, TweakingClassLoader.getSystemClassLoader());
        }
        try {
            if (this.cachedClasses.containsKey(name)) {
                return this.cachedClasses.get(name);
            }
            int lastDot = name.lastIndexOf(46);
            String packageName = lastDot == -1 ? "" : name.substring(0, lastDot);
            Package pkg = this.getPackage(packageName);
            if (pkg == null) {
                pkg = this.definePackage(packageName, null, null, null, null, null, null, null);
            } else if (pkg.isSealed()) {
                System.err.println("WHOOP, WHOOP, WHOOP");
            }
            byte[] clazzBytes = this.findClassBytes(name);
            clazzBytes = this.transformClass(name, clazzBytes);
            String classFileName = this.toInternalName(name) + ".class";
            URL g = this.findResource(classFileName);
            String h = g.toString();
            h = h.replaceAll("jar:", "").split("!")[0];
            URL classResource = new URL(h);
            ProtectionDomain domain = new ProtectionDomain(new CodeSource(classResource, new CodeSigner[0]), new Permissions());
            Class<?> clazz = this.defineClass(name, clazzBytes, 0, clazzBytes.length, domain);
            this.cachedClasses.put(name, clazz);
            return clazz;
        }
        catch (Throwable t) {
            throw new ClassNotFoundException("Failed to define " + name, t);
        }
    }

    private byte[] transformClass(String name, byte[] clazzBytes) {
        for (ClassTransformer classTransformer : this.classTransformers) {
            if (!classTransformer.shouldTransform(name)) continue;
            clazzBytes = classTransformer.transformClass(name, clazzBytes);
        }
        return clazzBytes;
    }

    public List<URL> getClasspath() {
        return this.classpath;
    }

    private URLConnection findUrlConnection(String name) {
        URL resource = this.findResource(name);
        if (resource == null) {
            return null;
        }
        try {
            return resource.openConnection();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addURL(URL url) {
        this.classpath.add(url);
        super.addURL(url);
    }

    @Override
    protected Class<?> findClass(String moduleName, String name) {
        try {
            return this.findClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] findClassBytes(String className) {
        String classFileName = this.toInternalName(className) + ".class";
        if (this.cachedResources.containsKey(classFileName)) {
            return this.cachedResources.get(classFileName);
        }
        URL classResource = this.findResource(classFileName);
        try {
            byte[] classBytes = classResource.openStream().readAllBytes();
            this.cachedResources.put(classFileName, classBytes);
            return classBytes;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load class: " + className, e);
        }
    }
}

