package com.ultreon.devices.api.app;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public interface IIcon {
    class_2960 getIconAsset();

    int getIconSize();

    int getGridWidth();

    int getGridHeight();

    /**
     * Width of the source texture in pixels.
     *
     * @return The source width.
     */
    int getSourceWidth();

    /**
     * Height of the source texture in pixels.
     *
     * @return The source height.
     */
    int getSourceHeight();

    int getU();

    int getV();

    int getOrdinal();

    default void draw(class_4587 pose, class_310 mc, int x, int y) {
        RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
        RenderSystem.setShaderTexture(0, getIconAsset());
        int size = getIconSize();
        int assetWidth = getGridWidth() * size;
//        java.lang.System.out.println("assetWidth = " + assetWidth);
        int assetHeight = getGridHeight() * size;
//        java.lang.System.out.println("assetHeight = " + assetHeight);
//        GuiComponent.blit(pose, x + contentX, y + iconY, iconWidth, iconHeight, iconU, iconV, iconWidth, iconHeight, iconSourceWidth, iconSourceHeight);
        class_332.method_25293(pose, x, y, size, size, getU(), getV(), size, size, assetWidth, assetHeight);
    }
}
