package com.ultreon.devices.api.app;

import com.ultreon.devices.api.task.Task;
import com.ultreon.devices.core.client.ClientNotification;
import com.ultreon.devices.network.PacketHandler;
import com.ultreon.devices.network.task.NotificationPacket;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.apache.commons.lang3.StringUtils;

/**
 * The notification class for the notification system.
 * <p>
 * This class is intended to be used only on the server (logical and physical) side only. Typically,
 * you'd want to be able to send a notification to anyone on the server. There is two options to
 * perform this, either create a background task on the server (a tick event) or send a
 * {@link Task} from the client to the server. It is not possible to
 * do this from the client side alone.
 * <p>
 * If a notification is needed to be produced on the client side only, see
 * {@link ClientNotification}
 */
public class Notification {
    private final IIcon icon;
    private final String title;
    private String subTitle;

    /**
     * The default constructor for a notification.
     *
     * @param icon  the icon to display
     * @param title the title of the notification
     */
    public Notification(IIcon icon, String title) {
        this.icon = icon;
        this.title = title;
    }

    /**
     * The alternate constructor for a notification. This includes a subtitle.
     *
     * @param icon     the icon to display
     * @param title    the title of the notification
     * @param subTitle the subtitle of the notification
     */
    public Notification(IIcon icon, String title, String subTitle) {
        this(icon, title);
        this.subTitle = subTitle;
    }

    /**
     * Writes the notification to a tag for the client
     *
     * @return the notification tag
     */
    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10582("title", title);

        if (!StringUtils.isEmpty(subTitle)) {
            tag.method_10582("subTitle", subTitle);
        }

        class_2487 tagIcon = new class_2487();
        tagIcon.method_10569("ordinal", icon.getOrdinal());
        tagIcon.method_10582("className", icon.getClass().getName());

        tag.method_10566("icon", tagIcon);

        return tag;
    }

    /**
     * Sends this notification to the specified player
     *
     * @param player the target player
     */
    public void pushTo(class_3222 player) {
        PacketHandler.sendToClient(new NotificationPacket(this), player);
    }
}
