package com.ultreon.devices.api.app.component;

import com.ultreon.devices.api.app.Component;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.util.GuiHelper;
import java.awt.*;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

@SuppressWarnings("unused")
public class Text extends Component {
    protected String rawText;
    protected List<String> lines;
    public int width;
    protected int padding;
    protected boolean shadow = false;

    protected int textColor = Color.WHITE.getRGB();

    private WordListener wordListener = null;

    /**
     * Default text constructor
     *
     * @param text  the text to display
     * @param left  how many pixels from the left
     * @param top   how many pixels from the top
     * @param width the max width
     */
    public Text(String text, int left, int top, int width) {
        super(left, top);
        this.width = width;
        this.setText(text);
    }

    @Override
    public void render(class_4587 pose, Laptop laptop, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
//        System.out.println(lines.size() + ", " + rawText + ", " + lines);
        if (this.visible) {
            for (int i = 0; i < lines.size(); i++) {
                String text = lines.get(i);
                while (text != null && text.endsWith("\n")) {
                    text = text.substring(0, text.length() - 1);
                }
                assert text != null;
                if (shadow) Laptop.getFont().method_1720(pose, text, x + padding, y + (i * 10) + padding, textColor);
                else Laptop.getFont().method_1729(pose, text, x + padding, y + (i * 10) + padding, textColor);
            }
        }
    }

    /**
     * Sets the text for this component
     *
     * @param text the text
     */
    public void setText(String text) {
        rawText = text;
        text = text.replace("\\n", "\n");
        var a = new ArrayList<String>();
        Laptop.getFont().method_27527().method_27495(class_5348.method_29430(text), width - padding * 2, class_2583.field_24360).forEach(b -> a.add(b.getString()));
        this.lines = a;
    }

    /**
     * Sets the text color for this component
     *
     * @param color the text color
     */
    public void setTextColor(Color color) {
        this.textColor = color.getRGB();
    }

    /**
     * Sets the whether shadow should show under the text
     *
     * @param shadow the text color
     */
    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    /**
     * @param padding the padding between the text and the edges of the component
     */
    public void setPadding(int padding) {
        this.padding = padding;
        this.updateLines();
    }

    private void updateLines() {
        this.setText(rawText);
    }

    @Override
    protected void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (GuiHelper.isMouseWithin(mouseX, mouseY, xPosition + padding, yPosition + padding, width - padding * 2, getHeight() - padding * 2)) {
            if (this.wordListener != null && lines.size() > 0) {
                int lineIndex = (mouseY - (yPosition + padding)) / 10;
                if (lineIndex < lines.size()) {
                    int cursorX = mouseX - (xPosition + padding);
                    String line = lines.get(lineIndex);
                    int index = Laptop.getFont().method_27523(line, cursorX).length();
                    String clickedWord = getWord(line, index);
                    if (clickedWord != null) {
                        this.wordListener.onWordClicked(clickedWord, mouseButton);
                    }
                }
            }
        }
    }

    private String getWord(String line, int index) {
        if (index >= line.length() || line.charAt(index) == ' ') return null;

        int startIndex = index;
        while (startIndex > 0 && line.charAt(startIndex - 1) != ' ') --startIndex;

        int endIndex = index;
        while (endIndex + 1 < line.length() && line.charAt(endIndex + 1) != ' ') ++endIndex;

        endIndex = Math.min(endIndex + 1, line.length());

        return class_124.method_539(line.substring(startIndex, endIndex));
    }

    public int getWidth() {
        return width;
    }

    public int getHeight() {
        return lines.size() * class_310.method_1551().field_1772.field_2000 + lines.size() - 1 + padding * 2;
    }

    public void setWordListener(WordListener wordListener) {
        this.wordListener = wordListener;
    }

    public boolean hasWordListener() {
        return this.wordListener != null;
    }

    public interface WordListener {
        void onWordClicked(String word, int mouseButton);
    }
}
