package com.ultreon.devices.api.print;

import com.ultreon.devices.init.DeviceBlocks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import javax.annotation.Nullable;

//printing somethings takes makes ink cartridge take damage. cartridge can only stack to one

/**
 * @author MrCrayfish
 */
public interface IPrint {
    static class_2487 save(IPrint print) {
        class_2487 tag = new class_2487();
        tag.method_10582("type", PrintingManager.getPrintIdentifier(print));
        tag.method_10566("data", print.toTag());
        return tag;
    }

    @Nullable
    static IPrint load(class_2487 tag) {
        IPrint print = PrintingManager.getPrint(tag.method_10558("type"));
        if (print != null) {
            print.fromTag(tag.method_10562("data"));
            return print;
        }
        return null;
    }

    static class_1799 generateItem(IPrint print) {
        class_2487 blockEntityTag = new class_2487();
        blockEntityTag.method_10566("print", save(print));

        class_2487 itemTag = new class_2487();
        itemTag.method_10566("BlockEntityTag", blockEntityTag);

        class_1799 stack = new class_1799(DeviceBlocks.PAPER.get());
        stack.method_7980(itemTag);

        if (print.getName() != null && !print.getName().isEmpty()) {
            stack.method_7977(class_2561.method_43470(print.getName()));
        }
        return stack;
    }

    String getName();

    /**
     * Gets the speed of the print. The higher the value, the longer it will take to print.
     *
     * @return the speed of this print
     */
    int speed();

    /**
     * Gets whether or not this print requires colored ink.
     *
     * @return if print requires ink
     */
    boolean requiresColor();

    /**
     * Converts print into an NBT tag compound. Used for the renderer.
     *
     * @return nbt form of print
     */
    class_2487 toTag();

    void fromTag(class_2487 tag);

    @Environment(EnvType.CLIENT)
    Class<? extends Renderer> getRenderer();

    interface Renderer {
        boolean render(class_4587 pose, class_2487 data);
    }
}
