package com.ultreon.devices.api.utils;

import ;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import com.ultreon.devices.api.app.component.Image;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.object.AppInfo;
import javax.annotation.Nullable;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import java.awt.*;

@SuppressWarnings("unused")
public class RenderUtil {
    public static void renderItem(int x, int y, class_1799 stack, boolean overlay) {
        RenderSystem.disableDepthTest();
        // Todo - Port to 1.18.2 if possible
//        RenderSystem.enableLighting();
        class_308.method_24210();
        //RenderSystem.setShader();
        class_310.method_1551().method_1480().method_4023(stack, x, y);
        if (overlay)
            class_310.method_1551().method_1480().method_4025(class_310.method_1551().field_1772, stack, x, y);

        // Todo - Port to 1.18.2 if possible
        //RenderSystem.enableAlpha();
        //Lighting.setupForFlatItems();
    }

    public static void drawIcon(class_4587 pose, double x, double y, AppInfo info, int width, int height) {
        RenderSystem.setShaderTexture(0, Laptop.ICON_TEXTURES);
        //Gui.blit(pose, (int) x, (int) y, width, height, u, v, sourceWidth, sourceHeight, (int) textureWidth, (int) textureHeight);
        if (info == null || (info.getIcon().getBase().getU() == -1 && info.getIcon().getBase().getV() == -1)) {
            drawRectWithTexture(pose, x, y, 0, 0, width, height, 14, 14, 224, 224);
            return;
        }
        RenderSystem.enableBlend();
        var glyphs = new AppInfo.Icon.Glyph[]{info.getIcon().getBase(), info.getIcon().getOverlay0(), info.getIcon().getOverlay1()};
        for (AppInfo.Icon.Glyph glyph : glyphs) {
            if (glyph.getU() == -1 || glyph.getV() == -1) continue;
            var col = new Color(info.getTint(glyph.getType()));
            int[] tint = new int[]{col.getRed(), col.getGreen(), col.getBlue()};
            RenderSystem.setShaderColor(tint[0]/255f, tint[1]/255f, tint[2]/255f, 1f);
            drawRectWithTexture(pose, x, y, glyph.getU(), glyph.getV(), width, height, 14, 14, 224, 224);
            //image.init(layout);
        }
        RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
    }

    public static void drawRectWithTexture(class_4587 pose, double x, double y, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        drawRectWithTexture(pose, x, y, 0, u, v, width, height, textureWidth, textureHeight);
        // Gui.blit(pose, (int) x, (int) y, width, height, u, v, width, height, (int) textureWidth, (int) textureHeight);
    }

    /**
     * Texture size must be 256x256
     *
     * @param pose          the pose stack to draw on
     * @param x             the x position of the rectangle
     * @param y             the y position of the rectangle
     * @param z             the z position of the rectangle
     * @param u             the x position of the texture
     * @param v             the y position of the texture
     * @param width         the width of the rectangle
     * @param height        the height of the rectangle
     * @param textureWidth  the width of the texture
     * @param textureHeight the height of the texture
     */
    public static void drawRectWithTexture(class_4587 pose, double x, double y, double z, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        //Gui.blit(pose, (int) x, (int) y, width, height, u, v, width, height, (int) textureWidth, (int) textureHeight);
        float scale = 0.00390625f;
        var e = pose.method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34542);
        class_287 buffer = class_289.method_1348().method_1349();
        try {
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        } catch (IllegalStateException e_) {
            buffer.method_1326();
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        }
        buffer.method_22918(e, (float) x, (float) (y + height), (float) z).method_22913(u * scale, (v + textureHeight) * scale).method_1344();
        buffer.method_22918(e, (float) (x + width), (float) (y + height), (float) z).method_22913((u + textureWidth) * scale, (v + textureHeight) * scale).method_1344();
        buffer.method_22918(e, (float) (x + width), (float) y, (float) z).method_22913((u + textureWidth) * scale, v * scale).method_1344();
        buffer.method_22918(e, (float) x, (float) y, (float) z).method_22913(u * scale, v * scale).method_1344();
        class_286.method_43433(buffer.method_1326());
    }

    public static void drawRectWithFullTexture(class_4587 pose, double x, double y, float u, float v, int width, int height) {
        // Gui.blit(pose, (int) x, (int) y, width, height, u, v, width, height, 256, 256);
        var e = pose.method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34542);
        class_287 buffer = class_289.method_1348().method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22918(e, (float) x, (float) (y + height), 0).method_22913(0, 1).method_1344();
        buffer.method_22918(e, (float) (x + width), (float) (y + height), 0).method_22913(1, 1).method_1344();
        buffer.method_22918(e, (float) (x + width), (float) y, 0).method_22913(1, 0).method_1344();
        buffer.method_22918(e, (float) x, (float) y, 0).method_22913(0, 0).method_1344();
        class_286.method_43433(buffer.method_1326());
    }

    public static void drawRectWithTexture(class_4587 pose, double x, double y, float u, float v, int width, int height, float textureWidth, float textureHeight, int sourceWidth, int sourceHeight) {
        //Gui.blit(pose, (int) x, (int) y, width, height, u, v, sourceWidth, sourceHeight, (int) textureWidth, (int) textureHeight);
        float scaleWidth = 1f / sourceWidth;
        float scaleHeight = 1f / sourceHeight;
        var e = pose.method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34542);
        class_287 buffer = class_289.method_1348().method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22918(e, (float) x, (float) (y + height), 0).method_22913(u * scaleWidth, (v + textureHeight) * scaleHeight).method_1344();
        buffer.method_22918(e, (float) (x + width), (float) (y + height), 0).method_22913((u + textureWidth) * scaleWidth, (v + textureHeight) * scaleHeight).method_1344();
        buffer.method_22918(e, (float) (x + width), (float) y, 0).method_22913((u + textureWidth) * scaleWidth, v * scaleHeight).method_1344();
        buffer.method_22918(e, (float) x, (float) y, 0).method_22913(u * scaleWidth, v * scaleHeight).method_1344();
        class_286.method_43433(buffer.method_1326());
    }

    public static void drawApplicationIcon(class_4587 pose, @Nullable AppInfo info, double x, double y) {
        //TODO: Reset color GlStateManager.color(1f, 1f, 1f);
        RenderSystem.setShaderTexture(0, Laptop.ICON_TEXTURES);
        if (info != null) {
            drawIcon(pose, x, y, info, 14, 14);
          //  drawRectWithTexture(pose, x, y, info.getIconU(), info.getIconV(), 14, 14, 14, 14, 224, 224);
        } else {
            drawRectWithTexture(pose, x, y, 0, 0, 14, 14, 14, 14, 224, 224);
        }
    }

    public static void drawStringClipped(class_4587 pose, String text, int x, int y, int width, int color, boolean shadow) {
        if (shadow) Laptop.getFont().method_1720(pose, clipStringToWidth(text, width) + class_124.field_1070, x, y, color);
        else Laptop.getFont().method_1729(pose, Laptop.getFont().method_27523(text, width) + class_124.field_1070, x, y, color);
    }

    public static String clipStringToWidth(String text, int width) {
        class_327 fontRenderer = Laptop.getFont();
        String clipped = text;
        if (fontRenderer.method_1727(clipped) > width) {
            clipped = fontRenderer.method_27523(clipped, width - 8) + "...";
        }
        return clipped;
    }

    public static boolean isMouseInside(int mouseX, int mouseY, int x1, int y1, int x2, int y2) {
        return mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2;
    }

    public static int color(int color, int defaultColor) {
        return color > 0 ? color : defaultColor;
    }
}
