package com.ultreon.devices.block;

import com.ultreon.devices.ModDeviceTypes;
import com.ultreon.devices.IDeviceType;
import com.ultreon.devices.block.entity.DeviceBlockEntity;
import com.ultreon.devices.util.BlockEntityUtil;
import com.ultreon.devices.util.Colorable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2383;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_5558;

@SuppressWarnings("deprecation")
public abstract class DeviceBlock extends class_2383 implements class_2343, IDeviceType {
    private final ModDeviceTypes deviceType;

    public DeviceBlock(class_2251 properties, ModDeviceTypes deviceType) {
        super(properties.method_9632(0.5f));
        this.deviceType = deviceType;
    }

//    @Override
//    public RenderShape getRenderShape(BlockState state) {
//        return RenderShape.INVISIBLE;
//    }

    @NotNull
    @Override
    public class_265 method_9530(@NotNull class_2680 pState, @NotNull class_1922 pLevel, @NotNull class_2338 pPos, @NotNull class_3726 pContext) {
        return class_259.method_1073();
    }

    @Nullable
    @Override
    public class_2680 method_9605(@NotNull class_1750 pContext) {
        class_2680 state = super.method_9605(pContext);
        return state != null ? state.method_11657(field_11177, Objects.requireNonNull(pContext.method_8036(), "Player in block placement context is null.").method_5735().method_10153()) : null;
    }

    @Override
    public void method_9567(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @Nullable class_1309 placer, @NotNull class_1799 stack) {
        super.method_9567(level, pos, state, placer, stack);

        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof DeviceBlockEntity deviceBlockEntity) {
            if (stack.method_7938()) {
                deviceBlockEntity.setCustomName(stack.method_7964().getString());
            }
        }
    }


    @Override
    public void method_9585(class_1936 level, class_2338 pos, class_2680 state) {
        if (!level.method_8608()) {
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity instanceof DeviceBlockEntity device) {
                class_2487 blockEntityTag = new class_2487();
                blockEntity.method_38244();
                blockEntityTag.method_10551("id");

                removeTagsForDrop(blockEntityTag);

                class_2487 tag = new class_2487();
                tag.method_10566("BlockEntityTag", blockEntityTag);

                class_1799 drop;
                if (blockEntity instanceof Colorable) {
                    drop = new class_1799(this, 1);
                } else {
                    drop = new class_1799(this);
                }
                drop.method_7980(tag);

                if (device.hasCustomName()) {
                    drop.method_7977(class_2561.method_43470(device.getCustomName()));
                }

                level.method_8649(new class_1542((class_1937) level, pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5, drop));

                level.method_8650(pos, false);
                return;
            }
        }
        super.method_9585(level, pos, state);
    }

    protected void removeTagsForDrop(class_2487 blockEntityTag) {

    }

    @Nullable
    @Override
    public abstract class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state);

    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 level, @NotNull class_2680 state, @NotNull class_2591<T> blockEntityType) {
        return BlockEntityUtil.getTicker();
    }

    @Override
    public boolean method_9592(@NotNull class_2680 state, class_1937 level, @NotNull class_2338 pos, int id, int param) {
        class_2586 blockEntity = level.method_8321(pos);
        return blockEntity != null && blockEntity.method_11004(id, param);
    }

    @Override
    public ModDeviceTypes getDeviceType() {
        return deviceType;
    }

    public static abstract class Colored extends DeviceBlock {
        private final class_1767 color;

        protected Colored(class_2251 properties, class_1767 color, ModDeviceTypes deviceType) {
            super(properties, deviceType);
            this.color = color;
        }

        public class_1767 getColor() {
            return color;
        }

        @Override
        public void method_9567(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @Nullable class_1309 placer, @NotNull class_1799 stack) {
            super.method_9567(level, pos, state, placer, stack);
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity instanceof Colorable colored) {
                colored.setColor(color);
            }
        }

        // Todo - Implement onDestroyedByPlayer if colored, and needed to implement it. Needs to check if it works without it.


        @Override
        protected void method_9515(class_2689.@NotNull class_2690<class_2248, class_2680> pBuilder) {
            super.method_9515(pBuilder);
            pBuilder.method_11667(field_11177);
        }
    }
}
