package com.ultreon.devices.block;

import com.ultreon.devices.ModDeviceTypes;
import com.ultreon.devices.block.entity.LaptopBlockEntity;
import com.ultreon.devices.item.FlashDriveItem;
import com.ultreon.devices.util.BlockEntityUtil;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Locale;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3542;
import net.minecraft.class_3614;
import net.minecraft.class_3726;
import net.minecraft.class_3965;

public class LaptopBlock extends DeviceBlock.Colored {
    public static final class_2754<Type> TYPE = class_2754.method_11850("type", Type.class);
    public static final class_2746 OPEN = class_2746.method_11825("open");

    private static final class_265 SHAPE_OPEN_NORTH = class_259.method_1084(class_2248.method_9541(1, 0, 12.5, 15, 11.4, 17), class_2248.method_9541(1, 0, 1, 15, 1.3, 12.5));
    private static final class_265 SHAPE_OPEN_EAST = class_259.method_1084(class_2248.method_9541(-1, 0, 1, 3.5, 11.4, 15), class_2248.method_9541(3.5, 0, 1, 15, 1.3, 15));
    private static final class_265 SHAPE_OPEN_SOUTH = class_259.method_1084(class_2248.method_9541(1, 0, -1, 15, 11.4, 3.5), class_2248.method_9541(1, 0, 3.5, 15, 1.3, 15));
    private static final class_265 SHAPE_OPEN_WEST = class_259.method_1084(class_2248.method_9541(12.5, 0, 1, 17, 11.4, 15), class_2248.method_9541(1, 0, 1, 12.5, 1.3, 15));
    private static final class_265 SHAPE_CLOSED_NORTH = class_2248.method_9541(1, 0, 1, 15, 2, 13);
    private static final class_265 SHAPE_CLOSED_EAST = class_2248.method_9541(3, 0, 1, 15, 2, 15);
    private static final class_265 SHAPE_CLOSED_SOUTH = class_2248.method_9541(1, 0, 3, 15, 2, 15);
    private static final class_265 SHAPE_CLOSED_WEST = class_2248.method_9541(1, 0, 1, 13, 2, 15);

    public LaptopBlock(class_1767 color) {
        super(class_2251.method_9617(class_3614.field_15949, color).method_9632(6f).method_9626(class_2498.field_11533), color, ModDeviceTypes.LAPTOP);
        method_9590(this.method_9595().method_11664().method_11657(TYPE, Type.BASE).method_11657(OPEN, false));
    }

    @Override
    public @NotNull class_265 method_9530(@NotNull class_2680 pState, @NotNull class_1922 pLevel, @NotNull class_2338 pPos, @NotNull class_3726 pContext) {
        return pState.method_11654(OPEN) ? switch (pState.getValue(FACING)) {
            case NORTH -> SHAPE_OPEN_NORTH;
            case EAST -> SHAPE_OPEN_EAST;
            case SOUTH -> SHAPE_OPEN_SOUTH;
            case WEST -> SHAPE_OPEN_WEST;
            default -> throw new IllegalStateException("Unexpected value: " + pState.getValue(FACING));
        } : switch (pState.getValue(FACING)) {
            case NORTH -> SHAPE_CLOSED_NORTH;
            case EAST -> SHAPE_CLOSED_EAST;
            case SOUTH -> SHAPE_CLOSED_SOUTH;
            case WEST -> SHAPE_CLOSED_WEST;
            default -> throw new IllegalStateException("Unexpected value: " + pState.getValue(FACING));
        };
    }

    @NotNull
    @Override
    @SuppressWarnings("deprecation")
    public class_1269 method_9534(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hit) {

        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof LaptopBlockEntity laptop) {
            if (player.method_18276()) {
                if (!level.field_9236) {
                    laptop.openClose(player);
                }
                return class_1269.field_5812;
            } else {
                if (hit.method_17780() == state.method_11654(field_11177).method_35834(class_2350.class_2351.field_11052)) {
                    class_1799 heldItem = player.method_5998(hand);
                    if (!heldItem.method_7960() && heldItem.method_7909() instanceof FlashDriveItem) {
                        if (!level.field_9236) {
                            if (laptop.getFileSystem().setAttachedDrive(heldItem.method_7972())) {
                                heldItem.method_7934(1);
                                return class_1269.field_21466;
                            } else {
                                return class_1269.field_5814;
                            }
                        }
                        return class_1269.field_5811;
                    }

                    if (!level.field_9236) {
                        class_1799 stack = laptop.getFileSystem().removeAttachedDrive();
                        if (stack != null) {
                            class_2338 summonPos = pos.method_10093(state.method_11654(field_11177).method_35834(class_2350.class_2351.field_11052));
                            level.method_8649(new class_1542(level, summonPos.method_10263() + 0.5, summonPos.method_10264(), summonPos.method_10260() + 0.5, stack));
                            BlockEntityUtil.markBlockForUpdate(level, pos);
                        }
                    }
                    return class_1269.field_5812;
                }

                if (laptop.isOpen() && level.field_9236) {
                    EnvExecutor.runInEnv(Env.CLIENT, () -> () -> {
                        ClientLaptopWrapper.execute(laptop);
                    });
                    return class_1269.field_5812;
                }
            }
        }

        return class_1269.field_5811;
    }

    @Override
    protected void removeTagsForDrop(class_2487 tileEntityTag) {
        tileEntityTag.method_10551("open");
    }

    @Override
    public @Nullable class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new LaptopBlockEntity(pos, state);
    }

    @Override
    protected void method_9515(class_2689.@NotNull class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder);
        pBuilder.method_11667(TYPE, OPEN);
    }

    public enum Type implements class_3542 {
        BASE, SCREEN;

        @NotNull
        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }
    }
}
