package com.ultreon.devices.block;

import com.ultreon.devices.api.print.IPrint;
import com.ultreon.devices.block.entity.PaperBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3614;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_47;

@SuppressWarnings("NullableProblems")
public class PaperBlock extends class_2383 implements class_2343 {
    private static final class_265 SELECTION_BOUNDS = method_9541(15, 0, 0, 16, 16, 16);

    private static final class_265 SELECTION_BOX_NORTH = method_9541(15, 0, 0, 16, 16, 16);
    private static final class_265 SELECTION_BOX_SOUTH = method_9541(0, 0, 0, 1, 16, 16);
    private static final class_265 SELECTION_BOX_WEST = method_9541(0, 0, 15, 16, 16, 16);
    private static final class_265 SELECTION_BOX_EAST = method_9541(0, 0, 0, 16, 16, 1);
    private static final class_265[] SELECTION_BOUNDING_BOX = {SELECTION_BOX_SOUTH, SELECTION_BOX_WEST, SELECTION_BOX_NORTH, SELECTION_BOX_EAST};

    public PaperBlock() {
        super(class_2251.method_9637(class_3614.field_15957).method_9634().method_9618().method_22488().method_42327());

        method_9590(method_9595().method_11664().method_11657(field_11177, class_2350.field_11043));
    }

    @NotNull
    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return switch (pState.getValue(FACING)) {
            case NORTH -> SELECTION_BOX_NORTH;
            case SOUTH -> SELECTION_BOX_SOUTH;
            case WEST -> SELECTION_BOX_WEST;
            case EAST -> SELECTION_BOX_EAST;
            default -> throw new IllegalStateException("Unexpected value: " + pState.getValue(FACING));
        };
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 pContext) {
        class_2680 state = super.method_9605(pContext);
        return state != null ? state.method_11657(field_11177, pContext.method_8042()) : null;
    }

    @Override
    public class_1269 method_9534(class_2680 pState, class_1937 level, class_2338 pPos, class_1657 pPlayer, class_1268 pHand, class_3965 pHit) {
        if (!level.field_9236) {
            class_2586 blockEntity = level.method_8321(pPos);
            if (blockEntity instanceof PaperBlockEntity paper) {
                paper.nextRotation();
            }
        }
        return class_1269.field_5812;
    }

    @Override
    public List<class_1799> method_9560(class_2680 pState, class_47.class_48 pBuilder) {
        return new ArrayList<>();
    }

    @Override
    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (!level.field_9236) {
            class_2586 tileEntity = level.method_8321(pos);
            if (tileEntity instanceof PaperBlockEntity paper) {
                class_1799 drop = IPrint.generateItem(paper.getPrint());
                level.method_8649(new class_1542(level, pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5, drop));
            }
        }
        super.method_9536(state, level, pos, newState, isMoving);
    }

    @Override
    public boolean method_9592(@NotNull class_2680 state, class_1937 level, @NotNull class_2338 pos, int id, int param) {
        class_2586 blockEntity = level.method_8321(pos);
        return blockEntity != null && blockEntity.method_11004(id, param);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        pBuilder.method_11667(field_11177);
    }

    // Todo: Port this to Minecraft 1.18.2
//    public EnumBlockRenderType getRenderType(IBlockState state) {
//        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
//    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PaperBlockEntity(pos, state);
    }
}
