package com.ultreon.devices.block;

import com.ultreon.devices.ModDeviceTypes;
import com.ultreon.devices.block.entity.PrinterBlockEntity;
import com.ultreon.devices.util.Colored;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3614;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author MrCrayfish
 */
public class PrinterBlock extends DeviceBlock.Colored implements Colored {
    private static final class_265 SHAPE_NORTH = class_259.method_17786(
            method_9541(2, 0, 7, 14, 5, 12),
            method_9541(3.5, 0.1, 1, 12.5, 1.1, 7),
            method_9541(12, 0, 12, 15, 5, 14),
            method_9541(12, 0, 5, 15, 3, 7),
            method_9541(1, 0, 5, 4, 3, 7),
            method_9541(1, 0, 12, 4, 5, 14),
            method_9541(1.1, 0, 7, 14.9, 5, 12),
            method_9541(4, 0, 12, 12, 3, 14),
            method_9541(3.5, 0.1, 1, 12.5, 1.1, 7.5),
            method_9541(1, 3, 5, 15, 5, 7),
            method_9541(4, 3, 12, 12, 9.3, 16));
    private static final class_265 SHAPE_EAST = class_259.method_17786(
            method_9541(4, 0, 2, 9, 5, 14),
            method_9541(9, 0.1, 3.5, 15, 1.1, 12.5),
            method_9541(2, 0, 12, 4, 5, 15),
            method_9541(9, 0, 12, 11, 3, 15),
            method_9541(9, 0, 1, 11, 3, 4),
            method_9541(2, 0, 1, 4, 5, 4),
            method_9541(4, 0, 1.1, 9, 5, 14.9),
            method_9541(2, 0, 4, 4, 3, 12),
            method_9541(8.5, 0.1, 3.5, 15, 1.1, 12.5),
            method_9541(9, 3, 1, 11, 5, 15),
            method_9541(0, 3, 4, 4, 9.3, 12));
    private static final class_265 SHAPE_SOUTH = class_259.method_17786(
            method_9541(2, 0, 4, 14, 5, 9),
            method_9541(3.5, 0.1, 9, 12.5, 1.1, 15),
            method_9541(1, 0, 2, 4, 5, 4),
            method_9541(1, 0, 9, 4, 3, 11),
            method_9541(12, 0, 9, 15, 3, 11),
            method_9541(12, 0, 2, 15, 5, 4),
            method_9541(1.1, 0, 4, 14.9, 5, 9),
            method_9541(4, 0, 2, 12, 3, 4),
            method_9541(3.5, 0.1, 8.5, 12.5, 1.1, 15),
            method_9541(1, 3, 9, 15, 5, 11),
            method_9541(4, 3, 0, 12, 9.3, 3.4));
    private static final class_265 SHAPE_WEST = class_259.method_17786(
            method_9541(7, 0, 2, 12, 5, 14),
            method_9541(1, 0.1, 3.5, 7, 1.1, 12.5),
            method_9541(12, 0, 1, 14, 5, 4),
            method_9541(5, 0, 1, 7, 3, 4),
            method_9541(5, 0, 12, 7, 3, 15),
            method_9541(12, 0, 12, 14, 5, 15),
            method_9541(7, 0, 1.1, 12, 5, 14.9),
            method_9541(12, 0, 4, 14, 3, 12),
            method_9541(1, 0.1, 3.5, 7.5, 1.1, 12.5),
            method_9541(5, 3, 1, 7, 5, 15),
            method_9541(12, 3, 4, 16, 9.3, 12));

    public PrinterBlock(class_1767 color) {
        super(class_2251.method_9617(class_3614.field_15949, color).method_9632(6f).method_9626(class_2498.field_11533), color, ModDeviceTypes.PRINTER);
        this.method_9590(method_9595().method_11664().method_11657(field_11177, class_2350.field_11043));
    }

    @NotNull
    @Override
    public class_265 method_9530(@NotNull class_2680 pState, @NotNull class_1922 pLevel, @NotNull class_2338 pPos, @NotNull class_3726 pContext) {
        return switch (pState.getValue(FACING)) {
            case NORTH -> SHAPE_NORTH;
            case EAST -> SHAPE_EAST;
            case SOUTH -> SHAPE_SOUTH;
            case WEST -> SHAPE_WEST;
            default -> throw new IllegalStateException("Unexpected value: " + pState.getValue(FACING));
        };
    }

    @NotNull
    @Override
    @SuppressWarnings("deprecation")
    public class_1269 method_9534(@NotNull class_2680 state, class_1937 level, @NotNull class_2338 pos, class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hit) {
        if (level.field_9236) {
            if (player.method_18276()) {
                return class_1269.field_5812;
            } else {
                return super.method_9534(state, level, pos, player, hand, hit);
            }
        }
        class_1799 heldItem = player.method_5998(hand);
        class_2586 tileEntity = level.method_8500(pos).method_12201(pos, class_2818.class_2819.field_12860);
        if (tileEntity instanceof PrinterBlockEntity) {
            return ((PrinterBlockEntity) tileEntity).addPaper(heldItem, player.method_18276()) ? class_1269.field_5812 : class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    @Override
    public @Nullable class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new PrinterBlockEntity(pos, state);
    }
}
