package com.ultreon.devices.block;

import com.ultreon.devices.ModDeviceTypes;
import com.ultreon.devices.block.entity.RouterBlockEntity;
import com.ultreon.devices.network.PacketHandler;
import com.ultreon.devices.network.task.SyncBlockPacket;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_3614;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

/**
 * @author MrCrayfish
 */
public class RouterBlock extends DeviceBlock.Colored {
    public static final class_2746 VERTICAL = class_2746.method_11825("vertical");

    // Todo - do rotations for voxel shapes properly.
    private static final class_265[] BODY_BOUNDING_BOX = {
            method_9541(4, 0, 2, 12, 2, 14),
            method_9541(4, 0, 2, 12, 2, 14),
            method_9541(4, 0, 2, 12, 2, 14),
            method_9541(4, 0, 2, 12, 2, 14)
    };
    private static final class_265[] BODY_VERTICAL_BOUNDING_BOX = {
            method_9541(14, 1, 2, 16, 9, 14),
            method_9541(14, 1, 2, 16, 9, 14),
            method_9541(14, 1, 2, 16, 9, 14),
            method_9541(14, 1, 2, 16, 9, 14)
    };
    private static final class_265[] SELECTION_BOUNDING_BOX = {
            method_9541(3, 0, 1, 13, 3, 15),
            method_9541(3, 0, 1, 13, 3, 15),
            method_9541(3, 0, 1, 13, 3, 15),
            method_9541(3, 0, 1, 13, 3, 15)
    };
    private static final class_265[] SELECTION_VERTICAL_BOUNDING_BOX = {
            method_9541(13, 0, 1, 16, 10, 15),
            method_9541(13, 0, 1, 16, 10, 15),
            method_9541(13, 0, 1, 16, 10, 15),
            method_9541(13, 0, 1, 16, 10, 15)
    };

    public RouterBlock(class_1767 color) {
        super(class_2251.method_9637(class_3614.field_15949).method_9632(6f).method_9626(class_2498.field_11533), color, ModDeviceTypes.ROUTER);
        this.method_9590(this.method_9595().method_11664().method_11657(field_11177, class_2350.field_11043).method_11657(VERTICAL, false));
    }

    @Override
    public @NotNull class_265 method_9530(@NotNull class_2680 pState, @NotNull class_1922 pLevel, @NotNull class_2338 pPos, @NotNull class_3726 pContext) {
        return switch (pState.getValue(FACING)) {
            case NORTH -> pState.getValue(VERTICAL) ? BODY_VERTICAL_BOUNDING_BOX[0] : BODY_BOUNDING_BOX[0];
            case EAST -> pState.getValue(VERTICAL) ? BODY_VERTICAL_BOUNDING_BOX[1] : BODY_BOUNDING_BOX[1];
            case SOUTH -> pState.getValue(VERTICAL) ? BODY_VERTICAL_BOUNDING_BOX[2] : BODY_BOUNDING_BOX[2];
            case WEST -> pState.getValue(VERTICAL) ? BODY_VERTICAL_BOUNDING_BOX[3] : BODY_BOUNDING_BOX[3];
            default -> BODY_BOUNDING_BOX[0];
        };
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (level.field_9236 && player.method_7337()) {
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity instanceof RouterBlockEntity router) {
                router.setDebug(true);
                if (router.isDebug()) {
                    PacketHandler.INSTANCE.sendToServer(new SyncBlockPacket(pos));
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Override
    public @org.jetbrains.annotations.Nullable class_2680 method_9605(@NotNull class_1750 pContext) {
        class_2680 state = super.method_9605(pContext);
        return state != null ? state.method_11657(field_11177, pContext.method_8042().method_10153()).method_11657(VERTICAL, pContext.method_17698().field_1351 - pContext.method_17698().field_1351 > 0.5) : null;
    }

//    @Override
//    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
//        IBlockState state = super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
//        return state.withProperty(VERTICAL, facing.getHorizontalIndex() != -1);
//    }

//    @Override
//    public boolean canPlaceBlockOnSide(World worldIn, BlockPos pos, EnumFacing side) {
//        return side != EnumFacing.DOWN;
//    }

    @NotNull
    @Override
    @Contract("_, _ -> new")
    public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new RouterBlockEntity(pos, state);
    }

    @Override
    protected void method_9515(class_2689.@NotNull class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder);
        pBuilder.method_11667(VERTICAL);
    }
}
