package com.ultreon.devices.block.entity;

import com.ultreon.devices.block.DeviceBlock;
import com.ultreon.devices.util.Colorable;
import com.ultreon.devices.util.Tickable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

import java.util.UUID;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public abstract class DeviceBlockEntity extends SyncBlockEntity implements Tickable {
    private class_1767 color = class_1767.field_7964;
    private UUID deviceId;
    private String name;

    public DeviceBlockEntity(class_2591<?> pType, class_2338 pWorldPosition, class_2680 pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    @NotNull
    public final UUID getId() {
        if (deviceId == null) {
            deviceId = UUID.randomUUID();
        }
        return deviceId;
    }

    public abstract String getDeviceName();

    public String getCustomName() {
        return hasCustomName() ? name : getDeviceName();
    }

    public void setCustomName(String name) {
        this.name = name;
    }

    public boolean hasCustomName() {
        return name != null && StringUtils.isEmpty(name);
    }

    public class_2561 getDisplayName() {
        return class_2561.method_43470(getCustomName());
    }

    @Override
    protected void method_11007(@NotNull class_2487 tag) {
        super.method_11007(tag);

        tag.method_10582("deviceId", getId().toString());
        if (hasCustomName()) {
            tag.method_10582("name", name);
        }

        tag.method_10567("color", (byte) color.method_7789());
    }

    @Override
    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);

        if (tag.method_10573("deviceId", class_2520.field_33258)) {
            deviceId = UUID.fromString(tag.method_10558("deviceId"));
        }
        if (tag.method_10573("name", class_2520.field_33258)) {
            name = tag.method_10558("name");
        }
        if (tag.method_10573("color", class_2520.field_33251)) {
            color = class_1767.method_7791(tag.method_10571("color"));
        }
    }

    @Override
    public class_2487 saveSyncTag() {
        class_2487 tag = new class_2487();
        if (hasCustomName()) {
            tag.method_10582("name", name);
        }

        tag.method_10567("color", (byte) color.method_7789());

        return tag;
    }

    public class_2248 getBlock() {
        return method_11010().method_26204();
    }

    public DeviceBlock getDeviceBlock() {
        class_2248 block = method_11010().method_26204();
        if (block instanceof DeviceBlock deviceBlock) {
            return deviceBlock;
        }
        return null;
    }

    public static abstract class Colored extends DeviceBlockEntity implements Colorable {
        private class_1767 color = class_1767.field_7964;

        public Colored(class_2591<?> pType, class_2338 pWorldPosition, class_2680 pBlockState) {
            super(pType, pWorldPosition, pBlockState);
        }

        @Override
        public void method_11014(@NotNull class_2487 tag) {
            super.method_11014(tag);
            if (tag.method_10573("color", class_2520.field_33251)) {
                color = class_1767.method_7791(tag.method_10571("color"));
            }
        }

        @Override
        protected void method_11007(@NotNull class_2487 tag) {
            super.method_11007(tag);
            tag.method_10567("color", (byte) color.method_7789());
        }

        @Override
        public class_2487 saveSyncTag() {
            class_2487 tag = super.saveSyncTag();
            tag.method_10567("color", (byte) color.method_7789());
            return tag;
        }

        public class_1767 getColor() {
            return color;
        }

        public void setColor(class_1767 color) {
            this.color = color;
        }
    }
}
