package com.ultreon.devices.block.entity;

import com.ultreon.devices.block.LaptopBlock;
import com.ultreon.devices.core.io.FileSystem;
import com.ultreon.devices.init.DeviceBlockEntities;
import com.ultreon.devices.util.BlockEntityUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaptopBlockEntity extends NetworkDeviceBlockEntity.Colored {
    private static final int OPENED_ANGLE = 102;

    private boolean open = false;

    private class_2487 applicationData = new class_2487();
    private class_2487 systemData = new class_2487();
    private FileSystem fileSystem;

    @Environment(EnvType.CLIENT)
    private int rotation;

    @Environment(EnvType.CLIENT)
    private int prevRotation;

    private class_1767 externalDriveColor;

    public LaptopBlockEntity(class_2338 pWorldPosition, class_2680 pBlockState) {
        super(DeviceBlockEntities.LAPTOP.get(), pWorldPosition, pBlockState);
    }

    @Override
    public String getDeviceName() {
        return "Laptop";
    }

    @Override
    public void tick() {
        super.tick();
        assert field_11863 != null;
        if (field_11863.field_9236) {
            prevRotation = rotation;
            if (!open) {
                if (rotation > 0) {
                    rotation -= 10;
                }
            } else {
                if (rotation < OPENED_ANGLE) {
                    rotation += 10;
                }
            }
        }
    }

    @Override
    public void method_11014(@NotNull class_2487 compound) {
        super.method_11014(compound);
        if (compound.method_10545("open")) {
            this.open = compound.method_10577("open");
            this.method_11010().method_11657(LaptopBlock.OPEN, open);
        }
        if (compound.method_10573("system_data", class_2520.field_33260)) {
            this.systemData = compound.method_10562("system_data");
        }
        if (compound.method_10573("application_data", class_2520.field_33260)) {
            this.applicationData = compound.method_10562("application_data");
        }
        if (compound.method_10545("file_system")) {
            this.fileSystem = new FileSystem(this, compound.method_10562("file_system"));
        }
        if (compound.method_10573("external_drive_color", class_2520.field_33251)) {
            this.externalDriveColor = null;
            if (compound.method_10571("external_drive_color") != -1) {
                this.externalDriveColor = class_1767.method_7791(compound.method_10571("external_drive_color"));
            }
        }
    }

    @Override
    public void method_11007(@NotNull class_2487 compound) {
        super.method_11007(compound);
        compound.method_10556("open", open);

        if (systemData != null) {
            compound.method_10566("system_data", systemData);
        }

        if (applicationData != null) {
            compound.method_10566("application_data", applicationData);
        }

        if (fileSystem != null) {
            compound.method_10566("file_system", fileSystem.toTag());
        }
    }

    @Override
    public class_2487 saveSyncTag() {
        class_2487 tag = super.saveSyncTag();
        tag.method_10556("open", open);
        tag.method_10566("system_data", getSystemData());

        if (getFileSystem().getAttachedDrive() != null) {
            tag.method_10567("external_drive_color", (byte) getFileSystem().getAttachedDriveColor().method_7789());
        } else {
            tag.method_10567("external_drive_color", (byte) -1);
        }

        return tag;
    }

    // Todo: Port to 1.18.2 if possible
//    @Override
//    public double getMaxRenderDistanceSquared() {
//        return 16384;
//    }
//
//    public AxisAlignedBB getRenderBoundingBox() {
//        return INFINITE_EXTENT_AABB;
//    }

    public void openClose(@Nullable class_1297 entity) {
        class_1937 level = this.field_11863;
        if (level != null) {
            level.method_43276(!open ? class_5712.field_28168 : class_5712.field_28169, method_11016(), class_5712.class_7397.method_43286(entity, this.method_11010()));
        }
        boolean oldOpen = open;
        open = !method_11010().method_11654(LaptopBlock.OPEN);
        if (oldOpen != open) {
            pipeline.method_10556("open", open);
            var d = method_11010().method_11657(LaptopBlock.OPEN, open);
            this.field_11863.method_8652(this.method_11016(), d, 18);
            sync();
        }

        if (level != null) {
            markUpdated();
            doNeighborUpdates(level, this.method_11016(), this.method_11010());
        }
    }

    private static void doNeighborUpdates(class_1937 level, class_2338 pos, class_2680 state) {
        state.method_30101(level, pos, 3);
    }

    public boolean isOpen() {
        return open;
    }

    public class_2487 getApplicationData() {
        return applicationData != null ? applicationData : new class_2487();
    }

    public class_2487 getSystemData() {
        if (systemData == null) {
            systemData = new class_2487();
        }
        return systemData;
    }

    public void setSystemData(class_2487 systemData) {
        this.systemData = systemData;
        method_5431();
        assert field_11863 != null;
        BlockEntityUtil.markBlockForUpdate(field_11863, field_11867);
    }

    public FileSystem getFileSystem() {
        if (fileSystem == null) {
            fileSystem = new FileSystem(this, new class_2487());
        }
        return fileSystem;
    }

    public void setApplicationData(String appId, class_2487 applicationData) {
        this.applicationData = applicationData;
        method_5431();
        assert field_11863 != null;
        BlockEntityUtil.markBlockForUpdate(field_11863, field_11867);
    }

    @Environment(EnvType.CLIENT)
    public float getScreenAngle(float partialTicks) {
        return -OPENED_ANGLE * ((prevRotation + (rotation - prevRotation) * partialTicks) / OPENED_ANGLE);
    }

    @Environment(EnvType.CLIENT)
    public boolean isExternalDriveAttached() {
        return externalDriveColor != null;
    }

    @Environment(EnvType.CLIENT)
    public class_1767 getExternalDriveColor() {
        return externalDriveColor;
    }
}
