package com.ultreon.devices.block.entity;

import com.ultreon.devices.DeviceConfig;
import com.ultreon.devices.core.network.Connection;
import com.ultreon.devices.core.network.Router;
import com.ultreon.devices.util.Colorable;
import com.ultreon.devices.util.Tickable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

@SuppressWarnings("unused")
public abstract class NetworkDeviceBlockEntity extends DeviceBlockEntity implements Tickable {
    private int counter;
    private Connection connection;

    public NetworkDeviceBlockEntity(class_2591<?> pType, class_2338 pWorldPosition, class_2680 pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    public void tick() {
        assert field_11863 != null;
        if (field_11863.field_9236)
            return;

        if (connection != null) {
            if (++counter >= DeviceConfig.BEACON_INTERVAL.get() * 2) {
                connection.setRouterPos(null);
                counter = 0;
            }
        }
    }

    public void connect(Router router) {
        assert field_11863 != null;
        if (router == null) {
            if (connection != null) {
                Router connectedRouter = connection.getRouter(field_11863);
                if (connectedRouter != null) {
                    connectedRouter.removeDevice(this);
                }
            }

            connection = null;
            return;
        }
        connection = new Connection(router);
        counter = 0;
        this.method_5431();
    }

    public Connection getConnection() {
        return connection;
    }

    @Nullable
    public Router getRouter() {
        return connection != null ? connection.getRouter(Objects.requireNonNull(field_11863)) : null;
    }

    public boolean isConnected() {
        return connection != null && connection.isConnected();
    }

    public boolean receiveBeacon(Router router) {
        if (counter >= DeviceConfig.BEACON_INTERVAL.get() * 2) {
            connect(router);
            return true;
        }
        if (connection != null && connection.getRouterId().equals(router.getId())) {
            connection.setRouterPos(router.getPos());
            counter = 0;
            return true;
        }
        return false;
    }

    public int getSignalStrength() {
        class_2338 routerPos = connection != null ? connection.getRouterPos() : null;
        if (routerPos != null) {
            double distance = Math.sqrt(field_11867.method_10268(routerPos.method_10263() + 0.5, routerPos.method_10264() + 0.5, routerPos.method_10260() + 0.5));
            double level = DeviceConfig.SIGNAL_RANGE.get() / 3d;
            return distance > level * 2 ? 2 : distance > level ? 1 : 0;
        }
        return -1;
    }

    @Nullable
    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43470(getCustomName());
    }

    @Override
    public void method_11007(@NotNull class_2487 tag) {
        super.method_11007(tag);
        if (connection != null) {
            tag.method_10566("connection", connection.toTag());
        }
    }

    @Override
    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10573("connection", class_2520.field_33260)) {
            connection = Connection.fromTag(tag.method_10562("connection"));
        }
    }

    public static abstract class Colored extends NetworkDeviceBlockEntity implements Colorable {
        private class_1767 color = class_1767.field_7964;

        public Colored(class_2591<?> pType, class_2338 pWorldPosition, class_2680 pBlockState) {
            super(pType, pWorldPosition, pBlockState);
        }

        @Override
        public void method_11014(@NotNull class_2487 tag) {
            super.method_11014(tag);
            if (tag.method_10573("color", class_2520.field_33258)) {
                color = class_1767.method_7791(tag.method_10571("color"));
            }
        }

        @Override
        public void method_11007(@NotNull class_2487 tag) {
            super.method_11007(tag);
            tag.method_10567("color", (byte) color.method_7789());
        }

        @Override
        public class_2487 saveSyncTag() {
            class_2487 tag = super.saveSyncTag();
            tag.method_10567("color", (byte) color.method_7789());
            return tag;
        }

        @Override
        public void setColor(class_1767 color) {
            this.color = color;
        }

        @Override
        public class_1767 getColor() {
            return color;
        }
    }
}
