package com.ultreon.devices.block.entity;

import com.ultreon.devices.api.print.IPrint;
import com.ultreon.devices.init.DeviceBlockEntities;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

/**
 * @author MrCrayfish
 */
public class PaperBlockEntity extends SyncBlockEntity {
    private IPrint print;
    private byte rotation;

    public PaperBlockEntity(class_2338 pWorldPosition, class_2680 pBlockState) {
        super(DeviceBlockEntities.PAPER.get(), pWorldPosition, pBlockState);
    }

    public void nextRotation() {
        rotation++;
        if (rotation > 7) {
            rotation = 0;
        }
        pipeline.method_10567("rotation", rotation);
        sync();
        playSound(class_3417.field_15038);
    }

    public float getRotation() {
        return rotation * 45f;
    }

    @Nullable
    public IPrint getPrint() {
        return print;
    }

    @Override
    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        if (compound.method_10573("print", class_2520.field_33260)) {
            print = IPrint.load(compound.method_10562("print"));
        }
        if (compound.method_10573("rotation", class_2520.field_33251)) {
            rotation = compound.method_10571("rotation");
        }
    }

    @Override
    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        if (print != null) {
            compound.method_10566("print", IPrint.save(print));
        }
        compound.method_10567("rotation", rotation);
    }

    @Override
    public class_2487 saveSyncTag() {
        class_2487 tag = new class_2487();
        if (print != null) {
            tag.method_10566("print", IPrint.save(print));
        }
        tag.method_10567("rotation", rotation);
        return tag;
    }

    private void playSound(class_3414 sound) {
        field_11863.method_8396(null, field_11867, sound, class_3419.field_15245, 1f, 1f);
    }
}
