package com.ultreon.devices.block.entity;

import com.ultreon.devices.DeviceConfig;
import com.ultreon.devices.api.print.IPrint;
import com.ultreon.devices.init.DeviceBlockEntities;
import com.ultreon.devices.init.DeviceSounds;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

import static com.ultreon.devices.block.entity.PrinterBlockEntity.State.*;

/**
 * @author MrCrayfish
 */
public class PrinterBlockEntity extends NetworkDeviceBlockEntity.Colored {
    private State state = IDLE;

    private final Deque<IPrint> printQueue = new ArrayDeque<>();
    private IPrint currentPrint;

    private int totalPrintTime;
    private int remainingPrintTime;
    private int paperCount = 0;

    public PrinterBlockEntity(class_2338 pWorldPosition, class_2680 pBlockState) {
        super(DeviceBlockEntities.PRINTER.get(), pWorldPosition, pBlockState);
    }

    @Override
    public void tick() {
        assert field_11863 != null;
        if (!field_11863.field_9236) {
            if (remainingPrintTime > 0) {
                if (remainingPrintTime % 20 == 0 || state == LOADING_PAPER) {
                    pipeline.method_10569("remainingPrintTime", remainingPrintTime);
                    sync();
                    if (remainingPrintTime != 0 && state == PRINTING) {
                        field_11863.method_8396(null, field_11867, DeviceSounds.PRINTER_PRINTING.get(), class_3419.field_15245, 0.5f, 1f);
                    }
                }
                remainingPrintTime--;
            } else {
                setState(state.next());
            }
        }

        if (state == IDLE && remainingPrintTime == 0 && currentPrint != null) {
            if (!field_11863.field_9236) {
//                BlockState state = level.getBlockState(worldPosition);
//                double[] fixedPosition = CollisionHelper.fixRotation(state.getValue(PrinterBlock.FACING), 0.15, 0.5, 0.15, 0.5);
                class_1542 entity = new class_1542(field_11863, field_11867.method_10263(), field_11867.method_10264() + 0.0625, field_11867.method_10260(), IPrint.generateItem(currentPrint));
                entity.method_18799(new class_243(0, 0, 0));
                field_11863.method_8649(entity);
            }
            currentPrint = null;
        }

        if (state == IDLE && currentPrint == null && !printQueue.isEmpty() && paperCount > 0) {
            print(printQueue.poll());
        }
    }

    @Override
    public String getDeviceName() {
        return "Printer";
    }

    @Override
    public void method_11014(@NotNull class_2487 compound) {
        super.method_11014(compound);
        if (compound.method_10573("currentPrint", class_2520.field_33260)) {
            currentPrint = IPrint.load(compound.method_10562("currentPrint"));
        }
        if (compound.method_10573("totalPrintTime", class_2520.field_33253)) {
            totalPrintTime = compound.method_10550("totalPrintTime");
        }
        if (compound.method_10573("remainingPrintTime", class_2520.field_33253)) {
            remainingPrintTime = compound.method_10550("remainingPrintTime");
        }
        if (compound.method_10573("state", class_2520.field_33253)) {
            state = State.values()[compound.method_10550("state")];
        }
        if (compound.method_10573("paperCount", class_2520.field_33253)) {
            paperCount = compound.method_10550("paperCount");
        }
        if (compound.method_10573("queue", class_2520.field_33259)) {
            printQueue.clear();
            class_2499 queue = compound.method_10554("queue", class_2520.field_33260);
            for (int i = 0; i < queue.size(); i++) {
                IPrint print = IPrint.load(queue.method_10602(i));
                printQueue.offer(print);
            }
        }
    }

    @Override
    public void method_11007(@NotNull class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("totalPrintTime", totalPrintTime);
        tag.method_10569("remainingPrintTime", remainingPrintTime);
        tag.method_10569("state", state.ordinal());
        tag.method_10569("paperCount", paperCount);
        if (currentPrint != null) {
            tag.method_10566("currentPrint", IPrint.save(currentPrint));
        }
        if (!printQueue.isEmpty()) {
            class_2499 queue = new class_2499();
            printQueue.forEach(print -> queue.add(IPrint.save(print)));
            tag.method_10566("queue", queue);
        }
    }

    @Override
    public class_2487 saveSyncTag() {
        class_2487 tag = super.saveSyncTag();
        tag.method_10569("paperCount", paperCount);
        return tag;
    }

    public void setState(State newState) {
        if (newState == null) return;

        state = newState;
        if (state == PRINTING) {
            if (DeviceConfig.OVERRIDE_PRINT_SPEED.get()) {
                remainingPrintTime = DeviceConfig.CUSTOM_PRINT_SPEED.get() * 20;
            } else {
                remainingPrintTime = currentPrint.speed() * 20;
            }
        } else {
            remainingPrintTime = state.animationTime;
        }
        totalPrintTime = remainingPrintTime;

        pipeline.method_10569("state", state.ordinal());
        pipeline.method_10569("totalPrintTime", totalPrintTime);
        pipeline.method_10569("remainingPrintTime", remainingPrintTime);
        sync();
    }

    public void addToQueue(IPrint print) {
        printQueue.offer(print);
    }

    private void print(IPrint print) {
        assert field_11863 != null;
        field_11863.method_8396(null, field_11867, DeviceSounds.PRINTER_LOADING_PAPER.get(), class_3419.field_15245, 0.5f, 1f);

        setState(LOADING_PAPER);
        currentPrint = print;
        paperCount--;

        pipeline.method_10569("paperCount", paperCount);
        pipeline.method_10566("currentPrint", IPrint.save(currentPrint));
        sync();
    }

    public boolean isLoading() {
        return state == LOADING_PAPER;
    }

    public boolean isPrinting() {
        return state == PRINTING;
    }

    public int getTotalPrintTime() {
        return totalPrintTime;
    }

    public int getRemainingPrintTime() {
        return remainingPrintTime;
    }

    public boolean addPaper(class_1799 stack, boolean addAll) {
        if (!stack.method_7960() && stack.method_7909() == class_1802.field_8407 && paperCount < DeviceConfig.MAX_PAPER_COUNT.get()) {
            if (!addAll) {
                paperCount++;
                stack.method_7934(1);
            } else {
                paperCount += stack.method_7947();
                stack.method_7939(Math.max(0, paperCount - 64));
                paperCount = Math.min(64, paperCount);
            }
            pipeline.method_10569("paperCount", paperCount);
            sync();
            assert field_11863 != null;
            field_11863.method_8396(null, field_11867, class_3417.field_14585, class_3419.field_15245, 1f, 1f);
            return true;
        }
        return false;
    }

    public boolean hasPaper() {
        return paperCount > 0;
    }

    public int getPaperCount() {
        return paperCount;
    }

    public IPrint getPrint() {
        return currentPrint;
    }

    public enum State {
        LOADING_PAPER(30), PRINTING(0), IDLE(0);

        final int animationTime;

        State(int time) {
            this.animationTime = time;
        }

        public State next() {
            if (ordinal() + 1 >= values().length) return null;
            return values()[ordinal() + 1];
        }
    }
}
