package com.ultreon.devices.block.entity;

import com.ultreon.devices.core.network.Router;
import com.ultreon.devices.init.DeviceBlockEntities;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;

@SuppressWarnings("unused")
public class RouterBlockEntity extends DeviceBlockEntity.Colored {
    private Router router;

    @Environment(EnvType.CLIENT)
    private int debugTimer;

    public RouterBlockEntity(class_2338 pWorldPosition, class_2680 pBlockState) {
        super(DeviceBlockEntities.ROUTER.get(), pWorldPosition, pBlockState);
    }

    public Router getRouter() {
        if (router == null) {
            router = new Router(field_11867);
            method_5431();
        }
        return router;
    }

    public void tick() {
        assert field_11863 != null;
        if (!field_11863.field_9236) {
            getRouter().tick(field_11863);
        } else if (debugTimer > 0) {
            debugTimer--;
        }
    }

    @Environment(EnvType.CLIENT)
    public boolean isDebug() {
        return debugTimer > 0;
    }

    @Environment(EnvType.CLIENT)
    public void setDebug(boolean debug) {
        if (debug) {
            debugTimer = 1200;
        } else {
            debugTimer = 0;
        }
    }

    public String getDeviceName() {
        return "Router";
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (tag.method_10573("router", class_2520.field_33260)) {
            router = Router.fromTag(field_11867, tag.method_10562("router"));
        }
    }

    public void syncDevicesToClient() {
        pipeline.method_10566("router", getRouter().toTag(true));
        sync();
    }

    // Todo - Maybe implement this whenever possible?
//    @Override
//    public double getMaxRenderDistanceSqr() {
//        return 16384;
//    }
//
//    @PlatformOnly("forge")
//    @Environment(EnvType.CLIENT)
//    @ExpectPlatform
//    public AABB getRenderBoundingBox() {
//        throw new AssertionError();
//    }
}
