package com.ultreon.devices.block.entity;

import com.ultreon.devices.annotations.PlatformOverride;
import com.ultreon.devices.util.BlockEntityUtil;
import dev.architectury.injectables.annotations.PlatformOnly;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2535;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;

public abstract class SyncBlockEntity extends class_2586 {
    protected class_2487 pipeline = new class_2487();

    public SyncBlockEntity(class_2591<?> pType, class_2338 pWorldPosition, class_2680 pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    public void sync() {
        assert field_11863 != null;
        BlockEntityUtil.markBlockForUpdate(field_11863, field_11867);
    }

    // from SignBlockEntity
    protected void markUpdated() {
        this.method_5431();
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    @PlatformOnly("forge")
    @PlatformOverride("forge")
    public void onDataPacket(class_2535 net, class_2622 pkt) {
        this.method_11014(Objects.requireNonNull(pkt.method_11290(), "The data packet for the block entity contained no data"));
    }

    @Override
    public class_2487 method_16887() {
        if (!pipeline.method_33133()) {
            class_2487 updateTag = pipeline;
            method_11007(updateTag);
            pipeline = new class_2487();
            return updateTag;
        }
        class_2487 updateTag = saveSyncTag();
        super.method_11007(updateTag);
        return updateTag;
    }

    public abstract class_2487 saveSyncTag();

    @Nullable
    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_39026(this, class_2586::method_16887);
    }

    public class_2487 getPipeline() {
        return pipeline;
    }
}
