package com.ultreon.devices.core;

import com.ultreon.devices.block.entity.DeviceBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;

public class Device {
    protected UUID id;
    protected String name;
    protected class_2338 pos;

    protected Device() {

    }

    public Device(@NotNull DeviceBlockEntity device) {
        this.id = device.getId();
        update(device);
    }

    public Device(@NotNull UUID id, @NotNull String name) {
        this.id = id;
        this.name = name;
    }

    @NotNull
    public UUID getId() {
        return id;
    }

    @NotNull
    public String getName() {
        return name;
    }

    @Nullable
    public class_2338 getPos() {
        return pos;
    }

    public void setPos(@Nullable class_2338 pos) {
        this.pos = pos;
    }

    public void update(@NotNull DeviceBlockEntity device) {
        name = device.getCustomName();
        pos = device.method_11016();
    }

    @Nullable
    public DeviceBlockEntity getDevice(@NotNull class_1937 level) {
        if (pos == null)
            return null;

        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof DeviceBlockEntity deviceBlockEntity) {
            if (deviceBlockEntity.getId().equals(getId())) {
                return deviceBlockEntity;
            }
        }

        return null;
    }

    public class_2487 toTag(boolean includePos) {
        class_2487 tag = new class_2487();
        tag.method_10582("id", getId().toString());
        tag.method_10582("name", getName());
        if (includePos) {
            tag.method_10544("pos", pos.method_10063());
        }
        return tag;
    }

    public static Device fromTag(class_2487 tag) {
        Device device = new Device();
        device.id = UUID.fromString(tag.method_10558("id"));
        device.name = tag.method_10558("name");
        if (tag.method_10573("pos", class_2520.field_33254)) {
            device.pos = class_2338.method_10092(tag.method_10537("pos"));
        }
        return device;
    }
}
