package com.ultreon.devices.core;

import F;
import I;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.Devices;
import com.ultreon.devices.Reference;
import com.ultreon.devices.api.ApplicationManager;
import com.ultreon.devices.api.app.*;
import com.ultreon.devices.api.app.component.Image;
import com.ultreon.devices.api.io.Drive;
import com.ultreon.devices.api.io.File;
import com.ultreon.devices.api.task.Callback;
import com.ultreon.devices.api.task.Task;
import com.ultreon.devices.api.task.TaskManager;
import com.ultreon.devices.block.entity.LaptopBlockEntity;
import com.ultreon.devices.core.task.TaskInstallApp;
import com.ultreon.devices.object.AppInfo;
import com.ultreon.devices.programs.system.DiagnosticsApp;
import com.ultreon.devices.programs.system.SystemApp;
import com.ultreon.devices.programs.system.component.FileBrowser;
import com.ultreon.devices.programs.system.task.TaskUpdateApplicationData;
import com.ultreon.devices.programs.system.task.TaskUpdateSystemData;
import com.ultreon.devices.util.GLHelper;
import dev.architectury.injectables.annotations.PlatformOnly;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nullable;
import net.minecraft.class_1109;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import java.awt.*;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.*;
import java.util.concurrent.CopyOnWriteArrayList;

//TODO Intro message (created by mrcrayfish, donate here)

/**
 * Laptop GUI class.
 *
 * @author MrCrayfish, Qboi123
 */
public class Laptop extends class_437 implements System {
    public static final int ID = 1;
    public static final class_2960 ICON_TEXTURES = new class_2960(Reference.MOD_ID, "textures/atlas/app_icons.png");
    public static final int ICON_SIZE = 14;
    private static final class_2960 LAPTOP_FONT = Devices.res("laptop");
    private static class_327 field_22793;
    private static final class_2960 LAPTOP_GUI = new class_2960(Reference.MOD_ID, "textures/gui/laptop.png");
    private static final List<Application> APPLICATIONS = new ArrayList<>();
    private static boolean worldLess;
    private static Laptop instance;

    @PlatformOnly("fabric")
    public static List<Application> getApplicationsForFabric() {
        return APPLICATIONS;
    }

    public static List<class_2960> getWallpapers() {
        return ImmutableList.copyOf(WALLPAPERS);
    }

    private static final List<class_2960> WALLPAPERS = new ArrayList<>();

    private static final int BORDER = 10;
    private static final int DEVICE_WIDTH = 384;
    static final int SCREEN_WIDTH = DEVICE_WIDTH - BORDER * 2;
    private static final int DEVICE_HEIGHT = 216;
    static final int SCREEN_HEIGHT = DEVICE_HEIGHT - BORDER * 2;
    private static final List<Runnable> tasks = new CopyOnWriteArrayList<>();
    private static System system;
    private static class_2338 pos;
    private static Drive mainDrive;
    private final Settings settings;
    private final TaskBar bar;
    final ArrayList<Window<?>> windows;
    private final class_2487 appData;
    private final class_2487 systemData;
    protected List<AppInfo> installedApps = new ArrayList<>();
    private Layout context = null;
    private Wallpaper currentWallpaper;
    private int lastMouseX, lastMouseY;
    private boolean dragging = false;
    private final IntArraySet pressed = new IntArraySet();
    private final com.ultreon.devices.api.app.component.Image wallpaper;
    private final Layout wallpaperLayout;
    private BSOD bsod;

    public static class_327 getFont() {
        if (field_22793 == null) {
            field_22793 = class_310.method_1551().field_1772;
        }
        return field_22793;
    }

    /**
     * Creates a new laptop GUI.
     *
     * @param laptop the block entity of the laptop in-game, if the laptop is not in-game, the level passed to it should be null.
     */
    public Laptop(LaptopBlockEntity laptop) {
        this(laptop, false);
    }

    /**
     * Creates a new laptop GUI.
     *
     * @param laptop the block entity of the laptop in-game, if the laptop is not in-game, the level passed to it should be null.
     */
    public Laptop(LaptopBlockEntity laptop, boolean worldLess) {
        super(class_2561.method_43470("Laptop"));

        instance = this;

        // Laptop data.
        this.appData = laptop.getApplicationData();
        this.systemData = laptop.getSystemData();

        // Windows
        this.windows = new ArrayList<>() {
            @Override
            public Window<?> get(int index) {
                try {
                    return super.get(index);
                } catch (Exception e) {
                    return null;
                }
            }

            @Override
            public boolean add(Window<?> window) {
                window.removed = false;
                return super.add(window);
            }
        };

        // Settings etc.
        this.settings = Settings.fromTag(systemData.method_10562("Settings"));

        // GUI Components
        this.bar = new TaskBar(this);

        // Wallpaper stuff
        this.currentWallpaper = systemData.method_10573("CurrentWallpaper", 10) ? new Wallpaper(systemData.method_10562("CurrentWallpaper")) : null;
        if (this.currentWallpaper == null) this.currentWallpaper = new Wallpaper(0);
        Laptop.system = this;
        Laptop.pos = laptop.method_11016();
        this.wallpaperLayout = new Layout(SCREEN_WIDTH, SCREEN_HEIGHT);
        this.wallpaper = new com.ultreon.devices.api.app.component.Image(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
        if (currentWallpaper.isBuiltIn()) {
            wallpaper.setImage(WALLPAPERS.get(currentWallpaper.location));
        } else {
            wallpaper.setImage(currentWallpaper.url);
        }
        this.wallpaperLayout.addComponent(this.wallpaper);
        this.wallpaperLayout.handleLoad();

        // World-less flag.
        Laptop.worldLess = worldLess;
    }

    public static boolean isWorldLess() {
        return worldLess;
    }

    /**
     * Returns the position of the laptop the player is currently using. This method can ONLY be
     * called when the laptop GUI is open, otherwise it will return a null position.
     *
     * @return the position of the laptop currently in use
     */
    @Nullable
    public static class_2338 getPos() {
        return pos;
    }

    /**
     * Add a wallpaper to the list of available wallpapers.
     *
     * @param wallpaper location to the wallpaper texture, if null the wallpaper will not be added.
     */
    public static void addWallpaper(class_2960 wallpaper) {
        if (wallpaper != null) {
            WALLPAPERS.add(wallpaper);
        }
    }

    public static System getSystem() {
        return system;
    }

    @Nullable
    public static Drive getMainDrive() {
        return mainDrive;
    }

    public static void setMainDrive(Drive mainDrive) {
        if (Laptop.mainDrive == null) {
            Laptop.mainDrive = mainDrive;
        }
    }

    /**
     * Run a task later in render thread.
     *
     * @param task the task to run.
     */
    public static void runLater(Runnable task) {
        tasks.add(task);
    }

    /**
     * Initialize the Laptop GUI.
     */
    @Override
    public void method_25426() {
        class_310.method_1551().field_1774.method_1462(true);
        int posX = (field_22789 - DEVICE_WIDTH) / 2;
        int posY = (field_22790 - DEVICE_HEIGHT) / 2;
        bar.init(posX + BORDER, posY + DEVICE_HEIGHT - 28);

        installedApps.clear();
        class_2499 list = systemData.method_10554("InstalledApps", class_2520.field_33258);
        for (int i = 0; i < list.size(); i++) {
            AppInfo info = ApplicationManager.getApplication(class_2960.method_12829(list.method_10608(i)));
            if (info != null) {
                installedApps.add(info);
            }
        }
        installedApps.sort(AppInfo.SORT_NAME);
        if (class_310.method_1551().method_1562() == null) {
            installedApps.addAll(ApplicationManager.getAvailableApplications());
        }
    }

    @Override
    public void method_25432() {
        class_310.method_1551().field_1774.method_1462(false);

        /* Close all windows and sendTask application data */
        for (int i = 0; i < windows.size(); i++) {
            Window<?> window = windows.get(i);
            if (window != null) {
                window.close();
                i--;
            }
        }

        /* Send system data */
        this.updateSystemData();

        Laptop.pos = null;
        Laptop.system = null;
        Laptop.mainDrive = null;
    }

    private void updateSystemData() {
        systemData.method_10566("CurrentWallpaper", currentWallpaper.serialize());
        systemData.method_10566("Settings", settings.toTag());

        class_2499 tagListApps = new class_2499();
        installedApps.forEach(info -> tagListApps.add(class_2519.method_23256(info.getFormattedId())));
        systemData.method_10566("InstalledApps", tagListApps);

        TaskManager.sendTask(new TaskUpdateSystemData(pos, systemData));
    }

    /**
     * Handles Minecraft GUI resizing.
     *
     * @param minecraft the Minecraft instance
     * @param width     the new width
     * @param height    the new height
     */
    @Override
    public void method_25410(@NotNull class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);
        for (var window : windows) {
            if (window != null) {
                window.content.markForLayoutUpdate();
            }
        }
    }

    /**
     * Ticking the laptop.
     */
    @Override
    public void method_25393() {
        try {
            bar.onTick();

            for (int i = 0; i < windows.size(); i++) {
                Window<?> window = windows.get(i);
                if (window != null) {
                    window.onTick();
                    if (window.removed) {
                //        java.lang.System.out.println("REMOVED " + window);
                   //     windows.remove(window);
                    //    i--;
                    }
                }
            }

            FileBrowser.refreshList = false;
        } catch (Exception e) {
            bsod(e);
        }
    }

    @Override
    public void method_25394(final @NotNull class_4587 pose, final int mouseX, final int mouseY, float partialTicks) {
        if (bsod != null) {
            renderBsod(pose, mouseX, mouseY, partialTicks);
            return;
        }

        class_4587.class_4665 last = pose.method_23760();

        try {
            renderLaptop(pose, mouseX, mouseY, partialTicks);
        } catch (NullPointerException e) {
            while (pose.method_23760() != last) {
                pose.method_22909();
            }
            RenderSystem.disableScissor();
            bsod(e);// null
        } catch (Exception e) {
            while (pose.method_23760() != last) {
                pose.method_22909();
            }
            RenderSystem.disableScissor();
            bsod(e);
        }
    }

    public void renderBsod(final @NotNull class_4587 pose, final int mouseX, final int mouseY, float partialTicks) {
        renderBezels(pose, mouseX, mouseY, partialTicks);
        int posX = (field_22789 - DEVICE_WIDTH) / 2;
        int posY = (field_22790 - DEVICE_HEIGHT) / 2;
        class_329.method_25294(pose, posX+10, posY+10, posX + DEVICE_WIDTH-10, posY + DEVICE_HEIGHT-10, new Color(0, 0, 255).getRGB());
        var bo = new ByteArrayOutputStream();

        double scale = class_310.method_1551().method_22683().method_4495();

        var b = new PrintStream(bo);
        bsod.throwable.printStackTrace(b);
        var str = bo.toString();
        drawLines(pose, Laptop.getFont(), str, posX+10, posY+10+getFont().field_2000*2, (int) ((DEVICE_WIDTH - 10) * scale), new Color(255, 255, 255).getRGB());
        pose.method_22903();
        pose.method_22905(2, 2, 0);
        pose.method_22904((posX+10)/2f,(posY+10)/2f,0);
        method_25303(pose, getFont(), "System has crashed!", 0, 0, new Color(255, 255, 255).getRGB());
        pose.method_22909();
    }

    public static void drawLines(class_4587 poseStack, class_327 font, String text, int x, int y, int width, int color) {
        var lines = new ArrayList<String>();
        font.method_27527().method_27495(class_5348.method_29430(text.replaceAll("\r\n", "\n").replaceAll("\r", "\n")), width, class_2583.field_24360).forEach(b -> lines.add(b.getString()));
        var totalTextHeight = font.field_2000*lines.size();
        var textScale = (DEVICE_HEIGHT-20-(getFont().field_2000*2))/(float)totalTextHeight;
        textScale = (float) (1f / class_310.method_1551().method_22683().method_4495());
        textScale = Math.max(0.5f, textScale);
        poseStack.method_22903();
        poseStack.method_22905(textScale, textScale, 1);
        poseStack.method_22904(x / textScale, (y+3)/textScale, 0);
        //poseStack.translate();
        var lineNr = 0;
        for (String s : lines) {
            font.method_1729(poseStack, s.replaceAll("\t", "    "), (float)0, (float)0+(lineNr*font.field_2000), color);
            lineNr++;
        }
        poseStack.method_22909();
    }

    public void renderBezels(final @NotNull class_4587 pose, final int mouseX, final int mouseY, float partialTicks) {
        tasks.clear();

        this.method_25420(pose);

        RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
        RenderSystem.setShaderTexture(0, LAPTOP_GUI);

        //*************************//
        //     Physical Screen     //
        //*************************//
        int posX = (field_22789 - DEVICE_WIDTH) / 2;
        int posY = (field_22790 - DEVICE_HEIGHT) / 2;

        // Corners
        method_25302(pose, posX, posY, 0, 0, BORDER, BORDER); // TOP-LEFT
        method_25302(pose, posX + DEVICE_WIDTH - BORDER, posY, 11, 0, BORDER, BORDER); // TOP-RIGHT
        method_25302(pose, posX + DEVICE_WIDTH - BORDER, posY + DEVICE_HEIGHT - BORDER, 11, 11, BORDER, BORDER); // BOTTOM-RIGHT
        method_25302(pose, posX, posY + DEVICE_HEIGHT - BORDER, 0, 11, BORDER, BORDER); // BOTTOM-LEFT

        // Edges
        class_329.method_25293(pose, posX + BORDER, posY, SCREEN_WIDTH, BORDER, 10, 0, 1, BORDER, 256, 256); // TOP
        class_329.method_25293(pose, posX + DEVICE_WIDTH - BORDER, posY + BORDER, BORDER, SCREEN_HEIGHT, 11, 10, BORDER, 1, 256, 256); // RIGHT
        class_329.method_25293(pose, posX + BORDER, posY + DEVICE_HEIGHT - BORDER, SCREEN_WIDTH, BORDER, 10, 11, 1, BORDER, 256, 256); // BOTTOM
        class_329.method_25293(pose, posX, posY + BORDER, BORDER, SCREEN_HEIGHT, 0, 11, BORDER, 1, 256, 256); // LEFT

        // Center
        class_329.method_25293(pose, posX + BORDER, posY + BORDER, SCREEN_WIDTH, SCREEN_HEIGHT, 10, 10, 1, 1, 256, 256);

    }

    /**
     * Render the laptop screen.
     *
     * @param pose         the pose stack.
     * @param mouseX       the current mouse X position.
     * @param mouseY       the current mouse Y position.
     * @param partialTicks the rendering partial ticks that forge give use (which is useless here).
     */
    public void renderLaptop(final @NotNull class_4587 pose, final int mouseX, final int mouseY, float partialTicks) {
        int posX = (field_22789 - DEVICE_WIDTH) / 2;
        int posY = (field_22790 - DEVICE_HEIGHT) / 2;
        // Fixes the strange partialTicks that Forge decided to give us
        final float frameTime = class_310.method_1551().method_1488();
        for (Runnable task : tasks) {
            task.run();
        }
        renderBezels(pose, mouseX, mouseY, partialTicks);
        //*******************//
        //     Wallpaper     //
        //*******************//
        //RenderSystem.setShaderTexture(0, WALLPAPERS.get(currentWallpaper));
        //RenderUtil.drawRectWithTexture(pose, posX + 10, posY + 10, 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, 512, 288);
        Image.CACHE.forEach((s, cachedImage) -> cachedImage.delete());
        this.wallpaperLayout.render(pose, this, this.field_22787, posX+10, posY+10, mouseX, mouseY, true, partialTicks);
        boolean insideContext = false;
        if (context != null) {
            insideContext = isMouseInside(mouseX, mouseY, context.xPosition, context.yPosition, context.xPosition + context.width, context.yPosition + context.height);
        }

        //****************//
        //     Window     //
        //****************//
        pose.method_22903();
        {
         //   Window<?>[] windows1 = Arrays.stream(windows.toArray()).filter(Objects::nonNull).toArray(Window<?>[]::new);
            for (int i = windows.size() - 1; i >= 0; i--) {
                var window = windows.get(i);
                if (window != null) {
                    class_4587.class_4665 last = pose.method_23760();
                    try {
                        if (i == 0) {
                            window.render(pose, this, field_22787, posX + BORDER, posY + BORDER, mouseX, mouseY, !insideContext, partialTicks);
                        } else {
                            window.render(pose, this, field_22787, posX + BORDER, posY + BORDER, Integer.MAX_VALUE, Integer.MAX_VALUE, false, partialTicks);
                        }
                    } catch (Exception e) {
                        while (pose.method_23760() != last) {
                            pose.method_22909();
                        }
                        RenderSystem.disableScissor();
                        e.printStackTrace();
                        Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
                        message.setTitle("Error");
                        class_2487 intent = new class_2487();
                        if (window.content instanceof Application app) {
                            AppInfo info = app.getInfo();
                            if (info != null) {
                                intent.method_10582("name", info.getName());
                            }
                            openApplication(ApplicationManager.getApplication(Devices.id("diagnostics")), intent);
                            closeApplication(app);
                        }
                    }
                    pose.method_22904(0, 0, 100);
                }
            }
        }
        pose.method_22909();

        //****************************//
        // Render the Application Bar //
        //****************************//
        bar.render(pose, this, field_22787, posX + 10, posY + DEVICE_HEIGHT - 28, mouseX, mouseY, frameTime);

        if (context != null) {
            context.render(pose, this, field_22787, context.xPosition, context.yPosition, mouseX, mouseY, true, frameTime);
        }

        Image.CACHE.entrySet().removeIf(entry -> {
            Image.CachedImage cachedImage = entry.getValue();
            if (cachedImage.isDynamic() && cachedImage.isPendingDeletion()) {
                int texture = cachedImage.getTextureId();
                if (texture != -1) {
                    RenderSystem.deleteTexture(texture);
                }
                return true;
            }
            return false;
        });

        super.method_25394(pose, mouseX, mouseY, frameTime);

        GLHelper.clearScissorStack();
    }

    private boolean isMouseInside(int mouseX, int mouseY, int startX, int startY, int endX, int endY) {
        return mouseX >= startX && mouseX <= endX && mouseY >= startY && mouseY <= endY;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        try {
            return mouseClickedInternal(mouseX, mouseY, mouseButton);
        } catch (NullPointerException e) {
            bsod(e);// null
        } catch (Exception e) {
            bsod(e);
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }
    private void bsod(Throwable e) {
        this.bsod = new BSOD(e);
        e.printStackTrace();
    }
    private static final class BSOD {
        private final Throwable throwable;
        public BSOD(Throwable e) {
            this.throwable = e;
        }
    }
    @SuppressWarnings("unchecked")
    public boolean mouseClickedInternal(double mouseX, double mouseY, int mouseButton) {
        this.lastMouseX = (int) mouseX;
        this.lastMouseY = (int) mouseY;

        int posX = (field_22789 - SCREEN_WIDTH) / 2;
        int posY = (field_22790 - SCREEN_HEIGHT) / 2;

        if (this.context != null) {
            int dropdownX = context.xPosition;
            int dropdownY = context.yPosition;
            if (isMouseInside((int) mouseX, (int) mouseY, dropdownX, dropdownY, dropdownX + context.width, dropdownY + context.height)) {
                this.context.handleMouseClick((int) mouseX, (int) mouseY, mouseButton);
                return false;
            } else {
                this.context = null;
            }
        }

        this.bar.handleClick(this, posX, posY + SCREEN_HEIGHT - TaskBar.BAR_HEIGHT, (int) mouseX, (int) mouseY, mouseButton);

        for (int i = 0; i < windows.size(); i++) {
            Window<Application> window = (Window<Application>) windows.get(i);
            if (window != null) {
                try {
                    Window<Dialog> dialogWindow = window.getContent().getActiveDialog();
                    if (isMouseWithinWindow((int) mouseX, (int) mouseY, window) || isMouseWithinWindow((int) mouseX, (int) mouseY, dialogWindow)) {
                        windows.remove(i);
                        i--;
                        updateWindowStack();
                        windows.add(0, window);

                        windows.get(0).handleMouseClick(this, posX, posY, (int) mouseX, (int) mouseY, mouseButton);

                        if (isMouseWithinWindowBar((int) mouseX, (int) mouseY, dialogWindow)) {
                            this.dragging = true;
                            return false;
                        }

                        if (isMouseWithinWindowBar((int) mouseX, (int) mouseY, window) && dialogWindow == null) {
                            this.dragging = true;
                            return false;
                        }
                        break;
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
                    message.setTitle("Error");
                    if (windows.size() == 0 || windows.get(0) == null) {
                        class_2487 intent = new class_2487();
                        AppInfo info = window.content.getInfo();
                        if (info != null) {
                            intent.method_10582("name", info.getName());
                        }
                        openApplication(ApplicationManager.getApplication(Devices.id("diagnostics")), intent);
                    } else {
                        windows.get(0).openDialog(message);
                    }
                }
            }
        }

        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int state) {
        super.method_25406(mouseX, mouseY, state);
        this.dragging = false;
        try {
            if (this.context != null) {
                int dropdownX = context.xPosition;
                int dropdownY = context.yPosition;
                if (isMouseInside((int) mouseX, (int) mouseY, dropdownX, dropdownY, dropdownX + context.width, dropdownY + context.height)) {
                    this.context.handleMouseRelease((int) mouseX, (int) mouseY, state);
                }
            } else if (windows.get(0) != null) {
                windows.get(0).handleMouseRelease((int) mouseX, (int) mouseY, state);
            }
        } catch (Exception e) {
            e.printStackTrace();
            Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
            message.setTitle("Error");
            windows.get(0).openDialog(message);
        }
        return true;
    }

    @Override
    public void method_37070() {
//        if (Keyboard.getEventKeyState()) {
//            char pressed = Keyboard.getEventCharacter();
//            int code = Keyboard.getEventKey();
//
//            if (windows[0] != null) {
//                windows[0].handleKeyTyped(pressed, code);
//            }
//
////            super.charTyped(pressed, code);
//        } else {
//        }

        // Todo - handle key presses
//        this.minecraft.dispatchKeypresses();
    }

    @Override
    public boolean method_25400(char codePoint, int modifiers) {
        boolean override = super.method_25400(codePoint, modifiers);
        try {
            if (!override && windows.get(0) != null)
                windows.get(0).handleCharTyped(codePoint, modifiers);
        } catch (Exception e) {
            e.printStackTrace();
            Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
            message.setTitle("Error");
            windows.get(0).openDialog(message);
        }
        return override;
    }

    @Override
    public boolean method_25404(final int keyCode, final int scanCode, final int modifiers) {
        final boolean override = super.method_25404(keyCode, scanCode, modifiers);

        try {
            if (!pressed.contains(keyCode) && !override && windows.get(0) != null) {
                windows.get(0).handleKeyPressed(keyCode, scanCode, modifiers);
            }
        } catch (Exception e) {
            e.printStackTrace();
            Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
            message.setTitle("Error");
            windows.get(0).openDialog(message);
        }
        pressed.add(keyCode);
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        pressed.remove(keyCode);

        boolean b = super.method_16803(keyCode, scanCode, modifiers);

        try {
            if (keyCode >= 32 && keyCode < 256 && windows.get(0) != null) {
                windows.get(0).handleKeyReleased(keyCode, scanCode, modifiers);
                return true;
            }
        } catch (Exception e) {
            e.printStackTrace();
            Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
            message.setTitle("Error");
            windows.get(0).openDialog(message);
        }
        return b;
    }

    @SuppressWarnings("unchecked")
    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        int posX = (field_22789 - SCREEN_WIDTH) / 2;
        int posY = (field_22790 - SCREEN_HEIGHT) / 2;

        try {
            if (this.context != null) {
                int dropdownX = context.xPosition;
                int dropdownY = context.yPosition;
                if (isMouseInside((int) mouseX, (int) mouseY, dropdownX, dropdownY, dropdownX + context.width, dropdownY + context.height)) {
                    this.context.handleMouseDrag((int) mouseX, (int) mouseY, button);
                }
                return true;
            }

            if (windows.get(0) != null) {
                Window<Application> window = (Window<Application>) windows.get(0);
                Window<Dialog> dialogWindow = window.getContent().getActiveDialog();
                if (dragging) {
                    if (isMouseOnScreen((int) mouseX, (int) mouseY)) {
                        Objects.requireNonNullElse(dialogWindow, window).handleWindowMove(posX, posY, (int) -(lastMouseX - mouseX), (int) -(lastMouseY - mouseY));
                    } else {
                        dragging = false;
                    }
                } else {
                    if (isMouseWithinWindow((int) mouseX, (int) mouseY, window) || isMouseWithinWindow((int) mouseX, (int) mouseY, dialogWindow)) {
                        window.handleMouseDrag((int) mouseX, (int) mouseY, button);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
            message.setTitle("Error");
            windows.get(0).openDialog(message);
        }
        this.lastMouseX = (int) mouseX;
        this.lastMouseY = (int) mouseY;
        return true;
    }

    @Override
    public void method_16014(double pMouseX, double pMouseY) {

    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (delta != 0) {
            try {
                if (windows.get(0) != null) {
                    windows.get(0).handleMouseScroll((int) mouseX, (int) mouseY, delta >= 0);
                }
            } catch (Exception e) {
                e.printStackTrace();
                Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
                message.setTitle("Error");
                windows.get(0).openDialog(message);
            }
        }
        return true;
    }

    @Override
    public void method_30901(@NotNull class_4587 pose, @NotNull List<class_2561> tooltips, int x, int y) {
        super.method_30901(pose, tooltips, x, y);
    }

    public Pair<Application, Boolean> sendApplicationToFront(AppInfo info) {
        int i = 0;
        for (; i < windows.size(); i++) {
            Window<?> window = windows.get(i);
            if (window != null && window.content instanceof Application && ((Application) window.content).getInfo() == info) {
                windows.remove(i);
                updateWindowStack();
                windows.add(0, window);
                i--;
                return Pair.of((Application) window.content, true);
            }
        }
        return Pair.of(null, false);
    }

    @Override
    public Application openApplication(AppInfo info) {
        return openApplication(info, (class_2487) null);
    }

    @Override
    public Application openApplication(AppInfo info, class_2487 intentTag) {
        Optional<Application> optional = APPLICATIONS.stream().filter(app -> app.getInfo() == info).findFirst();
        Application[] a = new Application[]{null};
        optional.ifPresent(application -> a[0] = openApplication(application, intentTag));
        return a[0];
    }

    private Application openApplication(Application app, class_2487 intent) {
        if (!(app instanceof DiagnosticsApp)) {
            if (isApplicationNotInstalled(app.getInfo()))
                return null;

            if (isInvalidApplication(app.getInfo()))
                return null;
        }

        try {
            var q = sendApplicationToFront(app.getInfo());
            if (q.right())
                return q.left();

            if (app instanceof SystemApp) {
                ((SystemApp) app).setLaptop(this);
            }

            if (app instanceof SystemAccessor) {
                ((SystemAccessor) app).sendSystem(this);
            }

            Window<Application> window = new Window<>(app, this);
            window.init((field_22789 - SCREEN_WIDTH) / 2, (field_22790 - SCREEN_HEIGHT) / 2, intent);

            if (appData.method_10545(app.getInfo().getFormattedId())) {
                app.load(appData.method_10562(app.getInfo().getFormattedId()));
            }

            if (app.getCurrentLayout() == null) {
                app.restoreDefaultLayout();
            }

            addWindow(window);

            class_310.method_1551().method_1483().method_4873(class_1109.method_4758(class_3417.field_15015, 1f));
        } catch (Exception e) {
            e.printStackTrace();
            AppInfo info = ApplicationManager.getApplication(Devices.id("diagnostics"));
            system.openApplication(info);
        }
        return app;
    }

    @Override
    public Pair<Application, Boolean> openApplication(AppInfo info, File file) {
        if (isApplicationNotInstalled(info))
            return Pair.of(null, false);

        if (isInvalidApplication(info))
            return Pair.of(null, false);

        try {
            Optional<Application> optional = APPLICATIONS.stream().filter(app -> app.getInfo() == info).findFirst();
            if (optional.isPresent()) {
                Application application = optional.get();
                boolean alreadyRunning = isApplicationRunning(info);
                openApplication(application, null);
                if (isApplicationRunning(info)) {
                    if (!application.handleFile(file)) {
                        if (!alreadyRunning) {
                            closeApplication(application);
                        }
                        return Pair.of(application, false);
                    }
                    return Pair.of(application, true);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            AppInfo info1 = ApplicationManager.getApplication(Devices.id("diagnostics"));
            system.openApplication(info1);
        }
        return Pair.of(null, true);
    }

    @Override
    public void closeApplication(AppInfo info) {
        Optional<Application> optional = APPLICATIONS.stream().filter(app -> app.getInfo() == info).findFirst();
        optional.ifPresent(this::closeApplication);
    }

    @SuppressWarnings("unchecked")
    private void closeApplication(Application app) {
        for (int i = 0; i < windows.size(); i++) {
            Window<Application> window = (Window<Application>) windows.get(i);
            if (window != null) {
                if (window.content.getInfo().equals(app.getInfo())) {
                    if (app.isDirty()) {
                        class_2487 container = new class_2487();
                        app.save(container);
                        app.clean();
                        appData.method_10566(app.getInfo().getFormattedId(), container);
                        TaskManager.sendTask(new TaskUpdateApplicationData(pos.method_10263(), pos.method_10264(), pos.method_10260(), app.getInfo().getFormattedId(), container));
                    }

                    if (app instanceof SystemApp) {
                        ((SystemApp) app).setLaptop(null);
                    }

                    window.handleClose();
                    windows.remove(i);
                    return;
                }
            }
        }
    }

    private void addWindow(Window<Application> window) {
        if (hasReachedWindowLimit())
            return;

        updateWindowStack();
        windows.add(0, window);
    }

    private void updateWindowStack() {
        for (int i = windows.size() - 1; i >= 0; i--) {
            if (windows.get(i) != null) {
                if (i + 1 < windows.size()) {
                    if (i == 0 || windows.get(i - 1) != null) {
                        if (windows.get(i + 1) == null) {
                            windows.add(i + 1, windows.get(i));
                            windows.remove(i);
                        }
                    }
                }
            }
        }
    }

    private boolean hasReachedWindowLimit() {
//        for (Window<?> window : windows) {
//           // if (window == null) return false;
//        }
        return false;
    }

    private boolean isMouseOnScreen(int mouseX, int mouseY) {
        int posX = (field_22789 - SCREEN_WIDTH) / 2;
        int posY = (field_22790 - SCREEN_HEIGHT) / 2;
        return isMouseInside(mouseX, mouseY, posX, posY, posX + SCREEN_WIDTH, posY + SCREEN_HEIGHT);
    }

    private boolean isMouseWithinWindowBar(int mouseX, int mouseY, Window<?> window) {
        if (window == null) return false;
        int posX = (field_22789 - SCREEN_WIDTH) / 2;
        int posY = (field_22790 - SCREEN_HEIGHT) / 2;
        return isMouseInside(mouseX, mouseY, posX + window.offsetX + 1, posY + window.offsetY + 1, posX + window.offsetX + window.width - 13, posY + window.offsetY + 11);
    }

    private boolean isMouseWithinWindow(int mouseX, int mouseY, Window<?> window) {
        if (window == null) return false;
        int posX = (field_22789 - SCREEN_WIDTH) / 2;
        int posY = (field_22790 - SCREEN_HEIGHT) / 2;
        return isMouseInside(mouseX, mouseY, posX + window.offsetX, posY + window.offsetY, posX + window.offsetX + window.width, posY + window.offsetY + window.height);
    }

    public boolean isMouseWithinApp(int mouseX, int mouseY, Window<?> window) {
        int posX = (field_22789 - SCREEN_WIDTH) / 2;
        int posY = (field_22790 - SCREEN_HEIGHT) / 2;
        return isMouseInside(mouseX, mouseY, posX + window.offsetX + 1, posY + window.offsetY + 13, posX + window.offsetX + window.width - 1, posY + window.offsetY + window.height - 1);
    }

    public boolean isApplicationRunning(AppInfo info) {
        for (Window<?> window : windows) {
            if (window != null && ((Application) window.content).getInfo() == info) {
                return true;
            }
        }
        return false;
    }

    public void nextWallpaper() {
        if (!currentWallpaper.isBuiltIn()) return;
        if (currentWallpaper.location + 1 < WALLPAPERS.size()) {
            this.currentWallpaper = new Wallpaper(currentWallpaper.location+1);
        }
        wallpaperUpdated();
    }

    public void prevWallpaper() {
        if (currentWallpaper.location - 1 >= 0) {
            this.currentWallpaper = new Wallpaper(currentWallpaper.location-1);
        }
        wallpaperUpdated();
    }

    private void wallpaperUpdated() {
        if (currentWallpaper.isBuiltIn()) {
            wallpaper.setImage(WALLPAPERS.get(currentWallpaper.location));
        } else {
            wallpaper.setImage(currentWallpaper.url);
        }
    }

    public void setWallpaper(String url) {
        currentWallpaper = new Wallpaper(url);
        wallpaperUpdated();
    }

    public void setWallpaper(int wall) {
        currentWallpaper = new Wallpaper(wall);
        wallpaperUpdated();
    }

    public Wallpaper getCurrentWallpaper() {
        return currentWallpaper;
    }

    public List<class_2960> getWallapapers() {
        return ImmutableList.copyOf(WALLPAPERS);
    }

    @Nullable
    public Application getApplication(String appId) {
        return APPLICATIONS.stream().filter(app -> app.getInfo().getFormattedId().equals(appId)).findFirst().orElse(null);
    }

    @Override
    public List<AppInfo> getInstalledApplications() {
        return ImmutableList.copyOf(installedApps);
    }

    public boolean isApplicationInstalled(AppInfo info) {
        return info.isSystemApp() || installedApps.contains(info);
    }

    public boolean isApplicationNotInstalled(AppInfo info) {
        return !isApplicationInstalled(info);
    }

    private boolean isValidApplication(AppInfo info) {
        if (Devices.hasAllowedApplications()) {
            return Devices.getAllowedApplications().contains(info);
        }
        return true;
    }

    private boolean isInvalidApplication(AppInfo info) {
        return !isValidApplication(info);
    }

    public void installApplication(AppInfo info, @Nullable Callback<Object> callback) {
        if (isValidApplication(info)) {
            Task task = new TaskInstallApp(info, pos, true);
            task.setCallback((tag, success) ->
            {
                if (success) {
                    installedApps.add(info);
                    installedApps.sort(AppInfo.SORT_NAME);
                }
                if (callback != null) {
                    callback.execute(null, success);
                }
            });
            TaskManager.sendTask(task);
        }
    }

    public void removeApplication(AppInfo info, @Nullable Callback<Object> callback) {
        if (!isValidApplication(info))
            return;

        Task task = new TaskInstallApp(info, pos, false);
        task.setCallback((tag, success) ->
        {
            if (success) {
                installedApps.remove(info);
            }
            if (callback != null) {
                callback.execute(null, success);
            }
        });
        TaskManager.sendTask(task);
    }

    public List<Application> getApplications() {
        return APPLICATIONS;
    }

    public TaskBar getTaskBar() {
        return bar;
    }

    public Settings getSettings() {
        return settings;
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    @Override
    public void openContext(Layout layout, int x, int y) {
        layout.updateComponents(x, y);
        context = layout;
        layout.init();
    }

    @Override
    public boolean hasContext() {
        return context != null;
    }

    @Override
    public void closeContext() {
        context = null;
        dragging = false;
    }

    public static final class Wallpaper {
        private final String url;
        private final int location;

        public String getUrl() {
            return url;
        }

        public int getLocation() {
            return location;
        }

        private Wallpaper(class_2487 tag) {
            var a = tag.method_10558("url");
            var b = tag.method_10550("location");
            if (tag.method_10573("url", 8)) {
                this.url = a;
                this.location = -87;
            } else {
                this.url = null;
                this.location = b;
            }
        }
        private Wallpaper(String url) {
            this.url = url;
            this.location = -87;
        }

        private Wallpaper(int location) {
            this.location = location;
            this.url = null;
        }

        public boolean isBuiltIn() {
            return this.location != -87;
        }

        public class_2520 serialize() {
            var a = new class_2487();
            if (isBuiltIn()) {
                a.method_10569("location", location);
            } else {
                a.method_10582("url", this.url);
            }
            return a;
        }
    }
}
