package com.ultreon.devices.core.io;

import com.ultreon.devices.api.app.Application;
import com.ultreon.devices.api.io.MimeType;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import permits;
import java.util.Comparator;

/**
 * @author MrCrayfish
 */
public sealed class ServerFile permits ServerFolder {
    public static final Comparator<ServerFile> SORT_BY_NAME = (f1, f2) -> {
        if (f1.isFolder() && !f2.isFolder()) return -1;
        if (!f1.isFolder() && f2.isFolder()) return 1;
        return f1.name.compareTo(f2.name);
    };
    private MimeType mimeType = MimeType.APPLICATION_OCTET_STREAM;

    protected ServerFolder parent;
    protected String name;
    protected String openingApp;
    protected class_2487 data;
    protected boolean protect = false;
    protected long lastModified;
    protected long lastAccessed;
    protected long creationTime;

    protected ServerFile() {

    }

    public ServerFile(String name, Application app, class_2487 data) {
        this(name, app.getInfo().getFormattedId(), data, false);
    }

    public ServerFile(String name, String openingAppId, class_2487 data) {
        this(name, openingAppId, data, false);
    }

    public ServerFile(String name, String openingAppId, MimeType mimeType, class_2487 data) {
        this(name, openingAppId, data, mimeType, false);
    }

    private ServerFile(String name, String openingAppId, class_2487 data,  boolean protect) {
        this(name, openingAppId, data, MimeType.APPLICATION_OCTET_STREAM, protect);
    }

    private ServerFile(String name, String openingAppId, class_2487 data, MimeType mimeType, boolean protect) {
        this.name = name;
        this.openingApp = openingAppId;
        this.data = data;
        this.mimeType = mimeType;
        this.protect = protect;
        this.creationTime = System.currentTimeMillis();
        this.lastModified = this.creationTime;
        this.lastAccessed = this.creationTime;
    }

    private ServerFile(String name, boolean protect, class_2487 tag) {
        this.openingApp = tag.method_10558("openingApp");
        this.name = name;
        this.data = tag.method_10562("data");
        this.creationTime = tag.method_10537("creationTime");
        this.lastModified = tag.method_10537("lastModified");
        this.lastAccessed = tag.method_10537("lastAccessed");
        this.protect = protect;
        this.mimeType = MimeType.of(tag.method_10562("mimeType"));
    }

    public String getName() {
        return name;
    }

    public FileSystem.Response rename(String name) {
        if (this.protect)
            return FileSystem.createResponse(FileSystem.Status.FILE_IS_PROTECTED, "Cannot rename a protected file");

        if (!FileSystem.PATTERN_FILE_NAME.matcher(name).matches())
            return FileSystem.createResponse(FileSystem.Status.FILE_INVALID_NAME, "Invalid file name");

        this.name = name;
        lastModified = System.currentTimeMillis();
        return FileSystem.createSuccessResponse();
    }

    @Nullable
    public String getOpeningApp() {
        return openingApp;
    }

    public FileSystem.Response setData(class_2487 data) {
        if (this.protect)
            return FileSystem.createResponse(FileSystem.Status.FILE_IS_PROTECTED, "Cannot set data on a protected file");

        if (data == null)
            return FileSystem.createResponse(FileSystem.Status.FILE_INVALID_DATA, "Invalid data");

        this.data = data;
        lastModified = System.currentTimeMillis();
        return FileSystem.createSuccessResponse();
    }

    @Nullable
    public class_2487 getData() {
        class_2487 data1 = data.method_10553(); // make a copy to prevent modifying the original data
        lastAccessed = System.currentTimeMillis();
        return data1;
    }

    @Nullable
    public ServerFolder getParent() {
        return parent;
    }

    public boolean isProtected() {
        return protect;
    }

    public boolean isFolder() {
        return false;
    }

    public long getCreationTime() {
        return creationTime;
    }

    public long getLastModified() {
        return lastModified;
    }

    public long getLastAccessed() {
        return lastAccessed;
    }

    public boolean isForApplication(Application app) {
        return openingApp != null && openingApp.equals(app.getInfo().getFormattedId());
    }

    public FileSystem.Response delete() {
        if (this.protect)
            return FileSystem.createResponse(FileSystem.Status.FILE_IS_PROTECTED, "Cannot delete a protected file");

        if (parent != null)
            return parent.delete(this);

        return FileSystem.createResponse(FileSystem.Status.FILE_INVALID, "Invalid file");
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10582("openingApp", openingApp);
        tag.method_10544("lastModified", lastModified);
        tag.method_10544("lastAccessed", lastAccessed);
        tag.method_10544("creationTime", creationTime);
        tag.method_10566("data", data);
        return tag;
    }

    public static ServerFile fromTag(String name, class_2487 tag) {
        return new ServerFile(name, false, tag);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null)
            return false;
        if (!(obj instanceof ServerFile))
            return false;
        return ((ServerFile) obj).name.equalsIgnoreCase(name);
    }

    public ServerFile copy() {
        return new ServerFile(name, openingApp, data.method_10553());
    }

    void onCreate() {
        creationTime = System.currentTimeMillis();
    }
}
