package com.ultreon.devices.core.io.action;

import com.ultreon.devices.api.io.File;
import com.ultreon.devices.api.io.Folder;
import net.minecraft.class_2487;

/**
 * @author MrCrayfish
 */
public class FileAction {
    private final Type type;
    private final class_2487 data;

    private FileAction(Type type, class_2487 data) {
        this.type = type;
        this.data = data;
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10569("type", type.ordinal());
        tag.method_10566("data", data);
        return tag;
    }

    public static FileAction fromTag(class_2487 tag) {
        Type type = Type.values()[tag.method_10550("type")];
        class_2487 data = tag.method_10562("data");
        return new FileAction(type, data);
    }

    public Type getType() {
        return type;
    }

    public class_2487 getData() {
        return data;
    }

    public enum Type {
        NEW, DELETE, RENAME, DATA, COPY_CUT
    }

    public static class Factory {
        public static FileAction makeNew(Folder parent, File file, boolean override) {
            class_2487 vars = new class_2487();
            vars.method_10582("directory", parent.getPath());
            vars.method_10582("file_name", file.getName());
            vars.method_10556("override", override);
            vars.method_10566("data", file.toTag());
            return new FileAction(Type.NEW, vars);
        }

        public static FileAction makeDelete(File file) {
            class_2487 vars = new class_2487();
            vars.method_10582("directory", file.getLocation());
            vars.method_10582("file_name", file.getName());
            return new FileAction(Type.DELETE, vars);
        }

        public static FileAction makeRename(File file, String newFileName) {
            class_2487 vars = new class_2487();
            vars.method_10582("directory", file.getLocation());
            vars.method_10582("file_name", file.getName());
            vars.method_10582("new_file_name", newFileName);
            return new FileAction(Type.RENAME, vars);
        }

        public static FileAction makeData(File file, class_2487 data) {
            class_2487 vars = new class_2487();
            vars.method_10582("directory", file.getLocation());
            vars.method_10582("file_name", file.getName());
            vars.method_10566("data", data);
            return new FileAction(Type.DATA, vars);
        }

        public static FileAction makeCopyCut(File source, Folder destination, boolean override, boolean cut) {
            class_2487 vars = new class_2487();
            vars.method_10582("directory", source.getLocation());
            vars.method_10582("file_name", source.getName());
            vars.method_10582("destination_drive", destination.getDrive().getUUID().toString());
            vars.method_10582("destination_folder", destination.getPath());
            vars.method_10556("override", override);
            vars.method_10556("cut", cut);
            return new FileAction(Type.COPY_CUT, vars);
        }
    }
}
