package com.ultreon.devices.core.io.drive;

import com.ultreon.devices.core.io.ServerFolder;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

/**
 * @author MrCrayfish
 */
public final class ExternalDrive extends AbstractDrive {
    private static final Predicate<class_2487> PREDICATE_DRIVE_TAG = tag -> tag.method_10573("name", class_2520.field_33258) && tag.method_10573("uuid", class_2520.field_33258) && tag.method_10573("root", class_2520.field_33260);

    private ExternalDrive() {
    }

    public ExternalDrive(String displayName) {
        super(displayName);
    }

    @Nullable
    public static AbstractDrive fromTag(class_2487 driveTag) {
        if (!PREDICATE_DRIVE_TAG.test(driveTag)) return null;

        AbstractDrive drive = new ExternalDrive();
        drive.name = driveTag.method_10558("name");
        drive.uuid = UUID.fromString(driveTag.method_10558("uuid"));

        class_2487 folderTag = driveTag.method_10562("root");
        drive.root = ServerFolder.fromTag(folderTag.method_10558("file_name"), folderTag.method_10562("data"));

        return drive;
    }

    @Override
    public class_2487 toTag() {
        class_2487 driveTag = new class_2487();
        driveTag.method_10582("name", name);
        driveTag.method_10582("uuid", uuid.toString());

        class_2487 folderTag = new class_2487();
        folderTag.method_10582("file_name", root.getName());
        folderTag.method_10566("data", root.toTag());
        driveTag.method_10566("root", folderTag);

        return driveTag;
    }

    @Override
    public Type getType() {
        return Type.EXTERNAL;
    }
}
