package com.ultreon.devices.core.io.drive;

import com.ultreon.devices.core.io.FileSystem;
import com.ultreon.devices.core.io.ServerFolder;
import com.ultreon.devices.core.io.action.FileAction;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;

/**
 * @author MrCrayfish
 */
public final class NetworkDrive extends AbstractDrive {
    private final class_2338 pos;

    public NetworkDrive(String name, class_2338 pos) {
        super(name);
        this.pos = pos;
        this.root = null;
    }

    @Nullable
    @Override
    public ServerFolder getRoot(class_1937 level) {
        class_2586 tileEntity = level.method_8321(pos);
        if (tileEntity instanceof Interface impl) {
            AbstractDrive drive = impl.getDrive();
            if (drive != null) {
                return drive.getRoot(level);
            }
        }
        return null;
    }

    @Override
    public FileSystem.Response handleFileAction(FileSystem fileSystem, FileAction action, class_1937 level) {
        class_2586 tileEntity = level.method_8321(pos);
        if (tileEntity instanceof Interface impl) {
            AbstractDrive drive = impl.getDrive();
            if (drive.handleFileAction(fileSystem, action, level).getStatus() == FileSystem.Status.SUCCESSFUL) {
                tileEntity.method_5431();
                return FileSystem.createSuccessResponse();
            }
        }
        return FileSystem.createResponse(FileSystem.Status.DRIVE_UNAVAILABLE, "The network drive could not be found");
    }

    @Nullable
    @Override
    public ServerFolder getFolder(String path) {
        return null;
    }

    @Override
    public Type getType() {
        return Type.NETWORK;
    }

    @Override
    public class_2487 toTag() {
        return null;
    }

    public interface Interface {
        AbstractDrive getDrive();

        boolean canAccessDrive();
    }
}
